/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.GraphProjectConfigBuilders;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.TestSupport;
import org.neo4j.gds.api.ImmutableGraphLoaderContext;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.GraphLoader;
import org.neo4j.gds.core.ImmutableGraphLoader;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.progress.EmptyTaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

@Value.Style(builderVisibility=Value.Style.BuilderVisibility.PUBLIC, depluralize=true, deepImmutablesDetection=true)
public final class GraphLoaderBuilders {
    private GraphLoaderBuilders() {
    }

    @Builder.Factory
    static GraphLoader storeLoader(GraphDatabaseAPI api, Optional<TransactionContext> transactionContext, Optional<ExecutorService> executorService, Optional<TerminationFlag> terminationFlag, Optional<Log> log, Optional<String> userName, Optional<String> graphName, List<String> nodeLabels, List<String> relationshipTypes, List<NodeProjection> nodeProjections, List<RelationshipProjection> relationshipProjections, Map<String, NodeProjection> nodeProjectionsWithIdentifier, Map<String, RelationshipProjection> relationshipProjectionsWithIdentifier, List<PropertyMapping> nodeProperties, List<PropertyMapping> relationshipProperties, Optional<Integer> concurrency, Optional<Orientation> globalOrientation, Optional<Aggregation> globalAggregation, Optional<Boolean> validateRelationships) {
        GraphProjectFromStoreConfig graphProjectConfig = GraphProjectConfigBuilders.storeConfig(userName.or(() -> transactionContext.map(TransactionContext::username)), graphName, nodeLabels, relationshipTypes, nodeProjections, relationshipProjections, nodeProjectionsWithIdentifier, relationshipProjectionsWithIdentifier, nodeProperties, relationshipProperties, concurrency, globalOrientation, globalAggregation, validateRelationships);
        return GraphLoaderBuilders.createGraphLoader(api, transactionContext, executorService, terminationFlag, log, userName, (GraphProjectConfig)graphProjectConfig);
    }

    @Builder.Factory
    static GraphLoader storeLoaderWithConfig(GraphDatabaseAPI api, Optional<TransactionContext> transactionContext, Optional<ExecutorService> executorService, Optional<TerminationFlag> terminationFlag, Optional<Log> log, Optional<String> userName, GraphProjectFromStoreConfig graphProjectConfig) {
        return GraphLoaderBuilders.createGraphLoader(api, transactionContext, executorService, terminationFlag, log, userName, (GraphProjectConfig)graphProjectConfig);
    }

    @Builder.Factory
    static GraphLoader cypherLoader(GraphDatabaseAPI api, Optional<TransactionContext> transactionContext, Optional<TerminationFlag> terminationFlag, Optional<Log> log, Optional<String> userName, Optional<String> graphName, Optional<String> nodeQuery, Optional<String> relationshipQuery, Optional<Integer> concurrency, Optional<Boolean> validateRelationships, Optional<Map<String, Object>> parameters) {
        GraphProjectFromCypherConfig graphProjectConfig = GraphProjectConfigBuilders.cypherConfig(userName.or(() -> transactionContext.map(TransactionContext::username)), graphName, nodeQuery, relationshipQuery, concurrency, validateRelationships, parameters);
        return GraphLoaderBuilders.createGraphLoader(api, transactionContext, Optional.empty(), terminationFlag, log, userName, (GraphProjectConfig)graphProjectConfig);
    }

    @NotNull
    public static GraphLoader createGraphLoader(GraphDatabaseAPI api, Optional<TransactionContext> transactionContext, Optional<ExecutorService> executorService, Optional<TerminationFlag> terminationFlag, Optional<Log> log, Optional<String> userName, GraphProjectConfig graphProjectConfig) {
        return ImmutableGraphLoader.builder().context(ImmutableGraphLoaderContext.builder().transactionContext(transactionContext.orElseGet(() -> TestSupport.fullAccessTransaction(api))).api(api).executor(executorService.orElse(Pools.DEFAULT)).terminationFlag(terminationFlag.orElse(TerminationFlag.RUNNING_TRUE)).taskRegistryFactory((TaskRegistryFactory)EmptyTaskRegistryFactory.INSTANCE).userLogRegistryFactory((UserLogRegistryFactory)EmptyUserLogRegistryFactory.INSTANCE).log(log.orElse((Log)NullLog.getInstance())).build()).username(userName.or(() -> transactionContext.map(TransactionContext::username)).orElse("")).projectConfig(graphProjectConfig).build();
    }
}

