/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.config.GraphProjectFromCypherConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.config.ImmutableGraphProjectFromCypherConfig;
import org.neo4j.gds.config.ImmutableGraphProjectFromStoreConfig;
import org.neo4j.gds.core.Aggregation;

@Value.Style(builderVisibility=Value.Style.BuilderVisibility.PUBLIC, depluralize=true, deepImmutablesDetection=true)
public final class GraphProjectConfigBuilders {
    private GraphProjectConfigBuilders() {
    }

    @Builder.Factory
    public static GraphProjectFromStoreConfig storeConfig(Optional<String> userName, Optional<String> graphName, List<String> nodeLabels, List<String> relationshipTypes, List<NodeProjection> nodeProjections, List<RelationshipProjection> relationshipProjections, Map<String, NodeProjection> nodeProjectionsWithIdentifier, Map<String, RelationshipProjection> relationshipProjectionsWithIdentifier, List<PropertyMapping> nodeProperties, List<PropertyMapping> relationshipProperties, Optional<Integer> concurrency, Optional<Orientation> globalProjection, Optional<Aggregation> globalAggregation, Optional<Boolean> validateRelationships) {
        LinkedHashMap<String, NodeProjection> tempNP = new LinkedHashMap<String, NodeProjection>();
        nodeLabels.forEach(label -> tempNP.put((String)label, NodeProjection.of((String)label, (PropertyMappings)PropertyMappings.of())));
        nodeProjections.forEach(np -> tempNP.put(np.label(), (NodeProjection)np));
        nodeProjectionsWithIdentifier.forEach(tempNP::put);
        if (tempNP.isEmpty()) {
            tempNP.put(NodeLabel.ALL_NODES.name, NodeProjection.all());
        }
        LinkedHashMap<String, RelationshipProjection> tempRP = new LinkedHashMap<String, RelationshipProjection>();
        Orientation orientation = globalProjection.orElse(Orientation.NATURAL);
        Aggregation aggregation = globalAggregation.orElse(Aggregation.DEFAULT);
        relationshipTypes.forEach(relType -> tempRP.put((String)relType, RelationshipProjection.of((String)relType, (Orientation)orientation, (Aggregation)aggregation)));
        relationshipProjections.forEach(rp -> tempRP.put(rp.type(), (RelationshipProjection)rp));
        relationshipProjectionsWithIdentifier.forEach(tempRP::put);
        if (tempRP.isEmpty()) {
            tempRP.put(RelationshipType.ALL_RELATIONSHIPS.name, RelationshipProjection.builder().type("*").orientation(orientation).aggregation(aggregation).build());
        }
        PropertyMappings relationshipPropertyMappings = PropertyMappings.builder().addAllMappings(relationshipProperties).withDefaultAggregation(aggregation).build();
        NodeProjections np2 = NodeProjections.of(tempNP.entrySet().stream().collect(Collectors.toMap(e -> NodeLabel.of((String)((String)e.getKey())), Map.Entry::getValue)));
        RelationshipProjections rp2 = RelationshipProjections.of(tempRP.entrySet().stream().collect(Collectors.toMap(e -> RelationshipType.of((String)((String)e.getKey())), Map.Entry::getValue)));
        return ImmutableGraphProjectFromStoreConfig.builder().username(userName.orElse("")).graphName(graphName.orElse("")).nodeProjections(np2).relationshipProjections(rp2).nodeProperties(PropertyMappings.of(nodeProperties)).relationshipProperties(relationshipPropertyMappings).readConcurrency(concurrency.orElse(4).intValue()).validateRelationships(validateRelationships.orElse(false).booleanValue()).build().withNormalizedPropertyMappings();
    }

    @Builder.Factory
    public static GraphProjectFromCypherConfig cypherConfig(Optional<String> userName, Optional<String> graphName, Optional<String> nodeQuery, Optional<String> relationshipQuery, Optional<Integer> concurrency, Optional<Boolean> validateRelationships, Optional<Map<String, Object>> parameters) {
        return ImmutableGraphProjectFromCypherConfig.builder().username(userName.orElse("")).graphName(graphName.orElse("")).nodeQuery(nodeQuery.orElse("MATCH (n) RETURN id(n) AS id")).relationshipQuery(relationshipQuery.orElse("MATCH (a)-->(b) RETURN id(a) AS source, id(b) AS target")).readConcurrency(concurrency.orElse(4).intValue()).validateRelationships(validateRelationships.orElse(true).booleanValue()).parameters(parameters.orElse(Collections.emptyMap())).build();
    }
}

