/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GdsCypher;
import org.neo4j.gds.ImmutablePropertyMapping;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.Aggregation;

@Generated(from="GdsCypher.inlineGraphProjectConfig", generator="Immutables")
final class InlineGraphProjectConfigBuilder {
    private Optional<String> graphName = Optional.empty();
    private Map<NodeLabel, NodeProjection> nodeProjections = new LinkedHashMap<NodeLabel, NodeProjection>();
    private Map<RelationshipType, RelationshipProjection> relProjections = new LinkedHashMap<RelationshipType, RelationshipProjection>();
    private List<PropertyMapping> nodeProperties = new ArrayList<PropertyMapping>();
    private List<PropertyMapping> relProperties = new ArrayList<PropertyMapping>();

    InlineGraphProjectConfigBuilder() {
    }

    public final InlineGraphProjectConfigBuilder graphName(String graphName) {
        this.graphName = Optional.of(graphName);
        return this;
    }

    public final InlineGraphProjectConfigBuilder graphName(Optional<String> graphName) {
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        return this;
    }

    public final InlineGraphProjectConfigBuilder putNodeProjection(NodeLabel key, NodeProjection value) {
        this.nodeProjections.put(Objects.requireNonNull(key, "nodeProjections key"), Objects.requireNonNull(value, "nodeProjections value"));
        return this;
    }

    public final InlineGraphProjectConfigBuilder putNodeProjection(Map.Entry<? extends NodeLabel, ? extends NodeProjection> entry) {
        NodeLabel k = entry.getKey();
        NodeProjection v = entry.getValue();
        this.nodeProjections.put(Objects.requireNonNull(k, "nodeProjections key"), Objects.requireNonNull(v, "nodeProjections value"));
        return this;
    }

    public final InlineGraphProjectConfigBuilder nodeProjections(Map<? extends NodeLabel, ? extends NodeProjection> entries) {
        this.nodeProjections.clear();
        return this.putAllNodeProjections(entries);
    }

    public final InlineGraphProjectConfigBuilder putAllNodeProjections(Map<? extends NodeLabel, ? extends NodeProjection> entries) {
        for (Map.Entry<? extends NodeLabel, ? extends NodeProjection> e : entries.entrySet()) {
            NodeLabel k = e.getKey();
            NodeProjection v = e.getValue();
            this.nodeProjections.put(Objects.requireNonNull(k, "nodeProjections key"), Objects.requireNonNull(v, "nodeProjections value"));
        }
        return this;
    }

    public final InlineGraphProjectConfigBuilder putRelProjection(RelationshipType key, RelationshipProjection value) {
        this.relProjections.put(Objects.requireNonNull(key, "relProjections key"), Objects.requireNonNull(value, "relProjections value"));
        return this;
    }

    public final InlineGraphProjectConfigBuilder putRelProjection(Map.Entry<? extends RelationshipType, ? extends RelationshipProjection> entry) {
        RelationshipType k = entry.getKey();
        RelationshipProjection v = entry.getValue();
        this.relProjections.put(Objects.requireNonNull(k, "relProjections key"), Objects.requireNonNull(v, "relProjections value"));
        return this;
    }

    public final InlineGraphProjectConfigBuilder relProjections(Map<? extends RelationshipType, ? extends RelationshipProjection> entries) {
        this.relProjections.clear();
        return this.putAllRelProjections(entries);
    }

    public final InlineGraphProjectConfigBuilder putAllRelProjections(Map<? extends RelationshipType, ? extends RelationshipProjection> entries) {
        for (Map.Entry<? extends RelationshipType, ? extends RelationshipProjection> e : entries.entrySet()) {
            RelationshipType k = e.getKey();
            RelationshipProjection v = e.getValue();
            this.relProjections.put(Objects.requireNonNull(k, "relProjections key"), Objects.requireNonNull(v, "relProjections value"));
        }
        return this;
    }

    public final InlineGraphProjectConfigBuilder addNodeProperty(PropertyMapping element) {
        element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
        this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
        return this;
    }

    public final InlineGraphProjectConfigBuilder addNodeProperty(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        return this.addNodeProperty(ImmutablePropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
    }

    public final InlineGraphProjectConfigBuilder addNodeProperties(PropertyMapping ... elements) {
        for (PropertyMapping element : elements) {
            element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
            this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
        }
        return this;
    }

    public final InlineGraphProjectConfigBuilder nodeProperties(Iterable<? extends PropertyMapping> elements) {
        this.nodeProperties.clear();
        return this.addAllNodeProperties(elements);
    }

    public final InlineGraphProjectConfigBuilder addAllNodeProperties(Iterable<? extends PropertyMapping> elements) {
        for (PropertyMapping propertyMapping : elements) {
            PropertyMapping propertyMapping2 = ImmutablePropertyMapping.copyOf((PropertyMapping)propertyMapping);
            this.nodeProperties.add(Objects.requireNonNull(propertyMapping2, "nodeProperties element"));
        }
        return this;
    }

    public final InlineGraphProjectConfigBuilder addRelProperty(PropertyMapping element) {
        element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
        this.relProperties.add(Objects.requireNonNull(element, "relProperties element"));
        return this;
    }

    public final InlineGraphProjectConfigBuilder addRelProperty(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        return this.addRelProperty(ImmutablePropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
    }

    public final InlineGraphProjectConfigBuilder addRelProperties(PropertyMapping ... elements) {
        for (PropertyMapping element : elements) {
            element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
            this.relProperties.add(Objects.requireNonNull(element, "relProperties element"));
        }
        return this;
    }

    public final InlineGraphProjectConfigBuilder relProperties(Iterable<? extends PropertyMapping> elements) {
        this.relProperties.clear();
        return this.addAllRelProperties(elements);
    }

    public final InlineGraphProjectConfigBuilder addAllRelProperties(Iterable<? extends PropertyMapping> elements) {
        for (PropertyMapping propertyMapping : elements) {
            PropertyMapping propertyMapping2 = ImmutablePropertyMapping.copyOf((PropertyMapping)propertyMapping);
            this.relProperties.add(Objects.requireNonNull(propertyMapping2, "relProperties element"));
        }
        return this;
    }

    public GraphProjectFromStoreConfig build() {
        return GdsCypher.inlineGraphProjectConfig(this.graphName, InlineGraphProjectConfigBuilder.createUnmodifiableMap(false, false, this.nodeProjections), InlineGraphProjectConfigBuilder.createUnmodifiableMap(false, false, this.relProjections), InlineGraphProjectConfigBuilder.createUnmodifiableList(true, this.nodeProperties), InlineGraphProjectConfigBuilder.createUnmodifiableList(true, this.relProperties));
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

