/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

public final class QueryRunner {
    private static final Result.ResultVisitor<RuntimeException> CONSUME_ROWS = ignore -> true;

    private QueryRunner() {
    }

    public static void runQueryWithRowConsumer(GraphDatabaseService db, String username, @Language(value="Cypher") String query, Map<String, Object> params, BiConsumer<Transaction, Result.ResultRow> rowConsumer) {
        GraphDatabaseApiProxy.runInTransaction((GraphDatabaseService)db, tx -> {
            try (KernelTransaction.Revertable ignored = QueryRunner.withUsername(tx, username, db.databaseName());
                 Result result = GraphDatabaseApiProxy.runQueryWithoutClosingTheResult((Transaction)tx, (String)query, (Map)params);){
                result.accept(row -> {
                    rowConsumer.accept((Transaction)tx, row);
                    return true;
                });
            }
        });
    }

    public static void runQueryWithRowConsumer(GraphDatabaseService db, @Language(value="Cypher") String query, Map<String, Object> params, BiConsumer<Transaction, Result.ResultRow> rowConsumer) {
        GraphDatabaseApiProxy.runInTransaction((GraphDatabaseService)db, tx -> {
            try (Result result = GraphDatabaseApiProxy.runQueryWithoutClosingTheResult((Transaction)tx, (String)query, (Map)params);){
                result.accept(row -> {
                    rowConsumer.accept((Transaction)tx, row);
                    return true;
                });
            }
        });
    }

    public static void runQueryWithRowConsumer(GraphDatabaseService db, @Language(value="Cypher") String query, Consumer<Result.ResultRow> rowConsumer) {
        GraphDatabaseApiProxy.runInTransaction((GraphDatabaseService)db, tx -> {
            try (Result result = GraphDatabaseApiProxy.runQueryWithoutClosingTheResult((Transaction)tx, (String)query, Collections.emptyMap());){
                result.accept(row -> {
                    rowConsumer.accept(row);
                    return true;
                });
            }
        });
    }

    public static void runQuery(GraphDatabaseService db, @Language(value="Cypher") String query) {
        QueryRunner.runQuery(db, query, Collections.emptyMap());
    }

    public static void runQuery(GraphDatabaseService db, @Language(value="Cypher") String query, Map<String, Object> params) {
        GraphDatabaseApiProxy.runInTransaction((GraphDatabaseService)db, tx -> {
            try (Result result = GraphDatabaseApiProxy.runQueryWithoutClosingTheResult((Transaction)tx, (String)query, (Map)params);){
                result.accept(CONSUME_ROWS);
            }
        });
    }

    public static <T> T runQuery(GraphDatabaseService db, String username, @Language(value="Cypher") String query, Map<String, Object> params, Function<Result, T> resultFunction) {
        return (T)GraphDatabaseApiProxy.applyInTransaction((GraphDatabaseService)db, tx -> {
            try (KernelTransaction.Revertable ignored = QueryRunner.withUsername(tx, username, db.databaseName());){
                Object r;
                block12: {
                    Result result = GraphDatabaseApiProxy.runQueryWithoutClosingTheResult((Transaction)tx, (String)query, (Map)params);
                    try {
                        r = resultFunction.apply(result);
                        if (result == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (result != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    result.close();
                }
                return r;
            }
        });
    }

    public static void runQuery(GraphDatabaseService db, String username, @Language(value="Cypher") String query, Map<String, Object> params) {
        GraphDatabaseApiProxy.runInTransaction((GraphDatabaseService)db, tx -> {
            try (KernelTransaction.Revertable ignored = QueryRunner.withUsername(tx, username, db.databaseName());
                 Result result = GraphDatabaseApiProxy.runQueryWithoutClosingTheResult((Transaction)tx, (String)query, (Map)params);){
                result.accept(CONSUME_ROWS);
            }
        });
    }

    public static <T> T runQuery(GraphDatabaseService db, @Language(value="Cypher") String query, Function<Result, T> resultFunction) {
        return QueryRunner.runQuery(db, query, Collections.emptyMap(), resultFunction);
    }

    public static <T> T runQuery(GraphDatabaseService db, @Language(value="Cypher") String query, Map<String, Object> params, Function<Result, T> resultFunction) {
        return (T)GraphDatabaseApiProxy.applyInTransaction((GraphDatabaseService)db, tx -> {
            try (Result result = GraphDatabaseApiProxy.runQueryWithoutClosingTheResult((Transaction)tx, (String)query, (Map)params);){
                Object r = resultFunction.apply(result);
                return r;
            }
        });
    }

    public static void runQueryWithResultConsumer(GraphDatabaseService db, @Language(value="Cypher") String query, Map<String, Object> params, Consumer<Result> resultConsumer) {
        GraphDatabaseApiProxy.runInTransaction((GraphDatabaseService)db, tx -> {
            try (Result result = GraphDatabaseApiProxy.runQueryWithoutClosingTheResult((Transaction)tx, (String)query, (Map)params);){
                resultConsumer.accept(result);
            }
        });
    }

    private static KernelTransaction.Revertable withUsername(Transaction tx, String username, String databaseName) {
        InternalTransaction topLevelTransaction = (InternalTransaction)tx;
        AuthSubject subject = topLevelTransaction.securityContext().subject();
        SecurityContext securityContext = Neo4jProxy.securityContext((String)username, (AuthSubject)subject, (AccessMode)AccessMode.Static.READ, (String)databaseName);
        return topLevelTransaction.overrideWith(securityContext);
    }
}

