/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphProjectConfigBuilders;
import org.neo4j.gds.ImmutablePropertyMapping;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.Aggregation;

@Generated(from="GraphProjectConfigBuilders.storeConfig", generator="Immutables")
public final class StoreConfigBuilder {
    private Optional<String> userName = Optional.empty();
    private Optional<String> graphName = Optional.empty();
    private List<String> nodeLabels = new ArrayList<String>();
    private List<String> relationshipTypes = new ArrayList<String>();
    private List<NodeProjection> nodeProjections = new ArrayList<NodeProjection>();
    private List<RelationshipProjection> relationshipProjections = new ArrayList<RelationshipProjection>();
    private Map<String, NodeProjection> nodeProjectionsWithIdentifier = new LinkedHashMap<String, NodeProjection>();
    private Map<String, RelationshipProjection> relationshipProjectionsWithIdentifier = new LinkedHashMap<String, RelationshipProjection>();
    private List<PropertyMapping> nodeProperties = new ArrayList<PropertyMapping>();
    private List<PropertyMapping> relationshipProperties = new ArrayList<PropertyMapping>();
    private Optional<Integer> concurrency = Optional.empty();
    private Optional<Orientation> globalProjection = Optional.empty();
    private Optional<Aggregation> globalAggregation = Optional.empty();
    private Optional<Boolean> validateRelationships = Optional.empty();

    public final StoreConfigBuilder userName(String userName) {
        this.userName = Optional.of(userName);
        return this;
    }

    public final StoreConfigBuilder userName(Optional<String> userName) {
        this.userName = Objects.requireNonNull(userName, "userName");
        return this;
    }

    public final StoreConfigBuilder graphName(String graphName) {
        this.graphName = Optional.of(graphName);
        return this;
    }

    public final StoreConfigBuilder graphName(Optional<String> graphName) {
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        return this;
    }

    public final StoreConfigBuilder addNodeLabel(String element) {
        this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
        return this;
    }

    public final StoreConfigBuilder addNodeLabels(String ... elements) {
        for (String element : elements) {
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
        }
        return this;
    }

    public final StoreConfigBuilder nodeLabels(Iterable<String> elements) {
        this.nodeLabels.clear();
        return this.addAllNodeLabels(elements);
    }

    public final StoreConfigBuilder addAllNodeLabels(Iterable<String> elements) {
        for (String element : elements) {
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
        }
        return this;
    }

    public final StoreConfigBuilder addRelationshipType(String element) {
        this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
        return this;
    }

    public final StoreConfigBuilder addRelationshipTypes(String ... elements) {
        for (String element : elements) {
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
        }
        return this;
    }

    public final StoreConfigBuilder relationshipTypes(Iterable<String> elements) {
        this.relationshipTypes.clear();
        return this.addAllRelationshipTypes(elements);
    }

    public final StoreConfigBuilder addAllRelationshipTypes(Iterable<String> elements) {
        for (String element : elements) {
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
        }
        return this;
    }

    public final StoreConfigBuilder addNodeProjection(NodeProjection element) {
        this.nodeProjections.add(Objects.requireNonNull(element, "nodeProjections element"));
        return this;
    }

    public final StoreConfigBuilder addNodeProjections(NodeProjection ... elements) {
        for (NodeProjection element : elements) {
            this.nodeProjections.add(Objects.requireNonNull(element, "nodeProjections element"));
        }
        return this;
    }

    public final StoreConfigBuilder nodeProjections(Iterable<? extends NodeProjection> elements) {
        this.nodeProjections.clear();
        return this.addAllNodeProjections(elements);
    }

    public final StoreConfigBuilder addAllNodeProjections(Iterable<? extends NodeProjection> elements) {
        for (NodeProjection nodeProjection : elements) {
            this.nodeProjections.add(Objects.requireNonNull(nodeProjection, "nodeProjections element"));
        }
        return this;
    }

    public final StoreConfigBuilder addRelationshipProjection(RelationshipProjection element) {
        this.relationshipProjections.add(Objects.requireNonNull(element, "relationshipProjections element"));
        return this;
    }

    public final StoreConfigBuilder addRelationshipProjections(RelationshipProjection ... elements) {
        for (RelationshipProjection element : elements) {
            this.relationshipProjections.add(Objects.requireNonNull(element, "relationshipProjections element"));
        }
        return this;
    }

    public final StoreConfigBuilder relationshipProjections(Iterable<? extends RelationshipProjection> elements) {
        this.relationshipProjections.clear();
        return this.addAllRelationshipProjections(elements);
    }

    public final StoreConfigBuilder addAllRelationshipProjections(Iterable<? extends RelationshipProjection> elements) {
        for (RelationshipProjection relationshipProjection : elements) {
            this.relationshipProjections.add(Objects.requireNonNull(relationshipProjection, "relationshipProjections element"));
        }
        return this;
    }

    public final StoreConfigBuilder putNodeProjectionsWithIdentifier(String key, NodeProjection value) {
        this.nodeProjectionsWithIdentifier.put(Objects.requireNonNull(key, "nodeProjectionsWithIdentifier key"), Objects.requireNonNull(value, "nodeProjectionsWithIdentifier value"));
        return this;
    }

    public final StoreConfigBuilder putNodeProjectionsWithIdentifier(Map.Entry<String, ? extends NodeProjection> entry) {
        String k = entry.getKey();
        NodeProjection v = entry.getValue();
        this.nodeProjectionsWithIdentifier.put(Objects.requireNonNull(k, "nodeProjectionsWithIdentifier key"), Objects.requireNonNull(v, "nodeProjectionsWithIdentifier value"));
        return this;
    }

    public final StoreConfigBuilder nodeProjectionsWithIdentifier(Map<String, ? extends NodeProjection> entries) {
        this.nodeProjectionsWithIdentifier.clear();
        return this.putAllNodeProjectionsWithIdentifier(entries);
    }

    public final StoreConfigBuilder putAllNodeProjectionsWithIdentifier(Map<String, ? extends NodeProjection> entries) {
        for (Map.Entry<String, ? extends NodeProjection> e : entries.entrySet()) {
            String k = e.getKey();
            NodeProjection v = e.getValue();
            this.nodeProjectionsWithIdentifier.put(Objects.requireNonNull(k, "nodeProjectionsWithIdentifier key"), Objects.requireNonNull(v, "nodeProjectionsWithIdentifier value"));
        }
        return this;
    }

    public final StoreConfigBuilder putRelationshipProjectionsWithIdentifier(String key, RelationshipProjection value) {
        this.relationshipProjectionsWithIdentifier.put(Objects.requireNonNull(key, "relationshipProjectionsWithIdentifier key"), Objects.requireNonNull(value, "relationshipProjectionsWithIdentifier value"));
        return this;
    }

    public final StoreConfigBuilder putRelationshipProjectionsWithIdentifier(Map.Entry<String, ? extends RelationshipProjection> entry) {
        String k = entry.getKey();
        RelationshipProjection v = entry.getValue();
        this.relationshipProjectionsWithIdentifier.put(Objects.requireNonNull(k, "relationshipProjectionsWithIdentifier key"), Objects.requireNonNull(v, "relationshipProjectionsWithIdentifier value"));
        return this;
    }

    public final StoreConfigBuilder relationshipProjectionsWithIdentifier(Map<String, ? extends RelationshipProjection> entries) {
        this.relationshipProjectionsWithIdentifier.clear();
        return this.putAllRelationshipProjectionsWithIdentifier(entries);
    }

    public final StoreConfigBuilder putAllRelationshipProjectionsWithIdentifier(Map<String, ? extends RelationshipProjection> entries) {
        for (Map.Entry<String, ? extends RelationshipProjection> e : entries.entrySet()) {
            String k = e.getKey();
            RelationshipProjection v = e.getValue();
            this.relationshipProjectionsWithIdentifier.put(Objects.requireNonNull(k, "relationshipProjectionsWithIdentifier key"), Objects.requireNonNull(v, "relationshipProjectionsWithIdentifier value"));
        }
        return this;
    }

    public final StoreConfigBuilder addNodeProperty(PropertyMapping element) {
        element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
        this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
        return this;
    }

    public final StoreConfigBuilder addNodeProperty(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        return this.addNodeProperty(ImmutablePropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
    }

    public final StoreConfigBuilder addNodeProperties(PropertyMapping ... elements) {
        for (PropertyMapping element : elements) {
            element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
            this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
        }
        return this;
    }

    public final StoreConfigBuilder nodeProperties(Iterable<? extends PropertyMapping> elements) {
        this.nodeProperties.clear();
        return this.addAllNodeProperties(elements);
    }

    public final StoreConfigBuilder addAllNodeProperties(Iterable<? extends PropertyMapping> elements) {
        for (PropertyMapping propertyMapping : elements) {
            PropertyMapping propertyMapping2 = ImmutablePropertyMapping.copyOf((PropertyMapping)propertyMapping);
            this.nodeProperties.add(Objects.requireNonNull(propertyMapping2, "nodeProperties element"));
        }
        return this;
    }

    public final StoreConfigBuilder addRelationshipProperty(PropertyMapping element) {
        element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
        this.relationshipProperties.add(Objects.requireNonNull(element, "relationshipProperties element"));
        return this;
    }

    public final StoreConfigBuilder addRelationshipProperty(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        return this.addRelationshipProperty(ImmutablePropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
    }

    public final StoreConfigBuilder addRelationshipProperties(PropertyMapping ... elements) {
        for (PropertyMapping element : elements) {
            element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
            this.relationshipProperties.add(Objects.requireNonNull(element, "relationshipProperties element"));
        }
        return this;
    }

    public final StoreConfigBuilder relationshipProperties(Iterable<? extends PropertyMapping> elements) {
        this.relationshipProperties.clear();
        return this.addAllRelationshipProperties(elements);
    }

    public final StoreConfigBuilder addAllRelationshipProperties(Iterable<? extends PropertyMapping> elements) {
        for (PropertyMapping propertyMapping : elements) {
            PropertyMapping propertyMapping2 = ImmutablePropertyMapping.copyOf((PropertyMapping)propertyMapping);
            this.relationshipProperties.add(Objects.requireNonNull(propertyMapping2, "relationshipProperties element"));
        }
        return this;
    }

    public final StoreConfigBuilder concurrency(int concurrency) {
        this.concurrency = Optional.of(concurrency);
        return this;
    }

    public final StoreConfigBuilder concurrency(Optional<Integer> concurrency) {
        this.concurrency = Objects.requireNonNull(concurrency, "concurrency");
        return this;
    }

    public final StoreConfigBuilder globalProjection(Orientation globalProjection) {
        this.globalProjection = Optional.of(globalProjection);
        return this;
    }

    public final StoreConfigBuilder globalProjection(Optional<? extends Orientation> globalProjection) {
        this.globalProjection = Objects.requireNonNull(globalProjection, "globalProjection");
        return this;
    }

    public final StoreConfigBuilder globalAggregation(Aggregation globalAggregation) {
        this.globalAggregation = Optional.of(globalAggregation);
        return this;
    }

    public final StoreConfigBuilder globalAggregation(Optional<? extends Aggregation> globalAggregation) {
        this.globalAggregation = Objects.requireNonNull(globalAggregation, "globalAggregation");
        return this;
    }

    public final StoreConfigBuilder validateRelationships(boolean validateRelationships) {
        this.validateRelationships = Optional.of(validateRelationships);
        return this;
    }

    public final StoreConfigBuilder validateRelationships(Optional<Boolean> validateRelationships) {
        this.validateRelationships = Objects.requireNonNull(validateRelationships, "validateRelationships");
        return this;
    }

    public GraphProjectFromStoreConfig build() {
        return GraphProjectConfigBuilders.storeConfig(this.userName, this.graphName, StoreConfigBuilder.createUnmodifiableList(true, this.nodeLabels), StoreConfigBuilder.createUnmodifiableList(true, this.relationshipTypes), StoreConfigBuilder.createUnmodifiableList(true, this.nodeProjections), StoreConfigBuilder.createUnmodifiableList(true, this.relationshipProjections), StoreConfigBuilder.createUnmodifiableMap(false, false, this.nodeProjectionsWithIdentifier), StoreConfigBuilder.createUnmodifiableMap(false, false, this.relationshipProjectionsWithIdentifier), StoreConfigBuilder.createUnmodifiableList(true, this.nodeProperties), StoreConfigBuilder.createUnmodifiableList(true, this.relationshipProperties), this.concurrency, this.globalProjection, this.globalAggregation, this.validateRelationships);
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

