/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.GraphLoaderBuilders;
import org.neo4j.gds.ImmutablePropertyMapping;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.GraphLoader;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

@Generated(from="GraphLoaderBuilders.storeLoader", generator="Immutables")
public final class StoreLoaderBuilder {
    private static final long INIT_BIT_API = 1L;
    private long initBits = 1L;
    private GraphDatabaseAPI api;
    private Optional<TransactionContext> transactionContext = Optional.empty();
    private Optional<ExecutorService> executorService = Optional.empty();
    private Optional<TerminationFlag> terminationFlag = Optional.empty();
    private Optional<Log> log = Optional.empty();
    private Optional<String> userName = Optional.empty();
    private Optional<String> graphName = Optional.empty();
    private List<String> nodeLabels = new ArrayList<String>();
    private List<String> relationshipTypes = new ArrayList<String>();
    private List<NodeProjection> nodeProjections = new ArrayList<NodeProjection>();
    private List<RelationshipProjection> relationshipProjections = new ArrayList<RelationshipProjection>();
    private Map<String, NodeProjection> nodeProjectionsWithIdentifier = new LinkedHashMap<String, NodeProjection>();
    private Map<String, RelationshipProjection> relationshipProjectionsWithIdentifier = new LinkedHashMap<String, RelationshipProjection>();
    private List<PropertyMapping> nodeProperties = new ArrayList<PropertyMapping>();
    private List<PropertyMapping> relationshipProperties = new ArrayList<PropertyMapping>();
    private Optional<Integer> concurrency = Optional.empty();
    private Optional<Orientation> globalOrientation = Optional.empty();
    private Optional<Aggregation> globalAggregation = Optional.empty();
    private Optional<Boolean> validateRelationships = Optional.empty();

    public final StoreLoaderBuilder api(GraphDatabaseAPI api) {
        this.api = Objects.requireNonNull(api, "api");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final StoreLoaderBuilder transactionContext(TransactionContext transactionContext) {
        this.transactionContext = Optional.of(transactionContext);
        return this;
    }

    public final StoreLoaderBuilder transactionContext(Optional<? extends TransactionContext> transactionContext) {
        this.transactionContext = Objects.requireNonNull(transactionContext, "transactionContext");
        return this;
    }

    public final StoreLoaderBuilder executorService(ExecutorService executorService) {
        this.executorService = Optional.of(executorService);
        return this;
    }

    public final StoreLoaderBuilder executorService(Optional<? extends ExecutorService> executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        return this;
    }

    public final StoreLoaderBuilder terminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = Optional.of(terminationFlag);
        return this;
    }

    public final StoreLoaderBuilder terminationFlag(Optional<? extends TerminationFlag> terminationFlag) {
        this.terminationFlag = Objects.requireNonNull(terminationFlag, "terminationFlag");
        return this;
    }

    public final StoreLoaderBuilder log(Log log) {
        this.log = Optional.of(log);
        return this;
    }

    public final StoreLoaderBuilder log(Optional<? extends Log> log) {
        this.log = Objects.requireNonNull(log, "log");
        return this;
    }

    public final StoreLoaderBuilder userName(String userName) {
        this.userName = Optional.of(userName);
        return this;
    }

    public final StoreLoaderBuilder userName(Optional<String> userName) {
        this.userName = Objects.requireNonNull(userName, "userName");
        return this;
    }

    public final StoreLoaderBuilder graphName(String graphName) {
        this.graphName = Optional.of(graphName);
        return this;
    }

    public final StoreLoaderBuilder graphName(Optional<String> graphName) {
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        return this;
    }

    public final StoreLoaderBuilder addNodeLabel(String element) {
        this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
        return this;
    }

    public final StoreLoaderBuilder addNodeLabels(String ... elements) {
        for (String element : elements) {
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
        }
        return this;
    }

    public final StoreLoaderBuilder nodeLabels(Iterable<String> elements) {
        this.nodeLabels.clear();
        return this.addAllNodeLabels(elements);
    }

    public final StoreLoaderBuilder addAllNodeLabels(Iterable<String> elements) {
        for (String element : elements) {
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
        }
        return this;
    }

    public final StoreLoaderBuilder addRelationshipType(String element) {
        this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
        return this;
    }

    public final StoreLoaderBuilder addRelationshipTypes(String ... elements) {
        for (String element : elements) {
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
        }
        return this;
    }

    public final StoreLoaderBuilder relationshipTypes(Iterable<String> elements) {
        this.relationshipTypes.clear();
        return this.addAllRelationshipTypes(elements);
    }

    public final StoreLoaderBuilder addAllRelationshipTypes(Iterable<String> elements) {
        for (String element : elements) {
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
        }
        return this;
    }

    public final StoreLoaderBuilder addNodeProjection(NodeProjection element) {
        this.nodeProjections.add(Objects.requireNonNull(element, "nodeProjections element"));
        return this;
    }

    public final StoreLoaderBuilder addNodeProjections(NodeProjection ... elements) {
        for (NodeProjection element : elements) {
            this.nodeProjections.add(Objects.requireNonNull(element, "nodeProjections element"));
        }
        return this;
    }

    public final StoreLoaderBuilder nodeProjections(Iterable<? extends NodeProjection> elements) {
        this.nodeProjections.clear();
        return this.addAllNodeProjections(elements);
    }

    public final StoreLoaderBuilder addAllNodeProjections(Iterable<? extends NodeProjection> elements) {
        for (NodeProjection nodeProjection : elements) {
            this.nodeProjections.add(Objects.requireNonNull(nodeProjection, "nodeProjections element"));
        }
        return this;
    }

    public final StoreLoaderBuilder addRelationshipProjection(RelationshipProjection element) {
        this.relationshipProjections.add(Objects.requireNonNull(element, "relationshipProjections element"));
        return this;
    }

    public final StoreLoaderBuilder addRelationshipProjections(RelationshipProjection ... elements) {
        for (RelationshipProjection element : elements) {
            this.relationshipProjections.add(Objects.requireNonNull(element, "relationshipProjections element"));
        }
        return this;
    }

    public final StoreLoaderBuilder relationshipProjections(Iterable<? extends RelationshipProjection> elements) {
        this.relationshipProjections.clear();
        return this.addAllRelationshipProjections(elements);
    }

    public final StoreLoaderBuilder addAllRelationshipProjections(Iterable<? extends RelationshipProjection> elements) {
        for (RelationshipProjection relationshipProjection : elements) {
            this.relationshipProjections.add(Objects.requireNonNull(relationshipProjection, "relationshipProjections element"));
        }
        return this;
    }

    public final StoreLoaderBuilder putNodeProjectionsWithIdentifier(String key, NodeProjection value) {
        this.nodeProjectionsWithIdentifier.put(Objects.requireNonNull(key, "nodeProjectionsWithIdentifier key"), Objects.requireNonNull(value, "nodeProjectionsWithIdentifier value"));
        return this;
    }

    public final StoreLoaderBuilder putNodeProjectionsWithIdentifier(Map.Entry<String, ? extends NodeProjection> entry) {
        String k = entry.getKey();
        NodeProjection v = entry.getValue();
        this.nodeProjectionsWithIdentifier.put(Objects.requireNonNull(k, "nodeProjectionsWithIdentifier key"), Objects.requireNonNull(v, "nodeProjectionsWithIdentifier value"));
        return this;
    }

    public final StoreLoaderBuilder nodeProjectionsWithIdentifier(Map<String, ? extends NodeProjection> entries) {
        this.nodeProjectionsWithIdentifier.clear();
        return this.putAllNodeProjectionsWithIdentifier(entries);
    }

    public final StoreLoaderBuilder putAllNodeProjectionsWithIdentifier(Map<String, ? extends NodeProjection> entries) {
        for (Map.Entry<String, ? extends NodeProjection> e : entries.entrySet()) {
            String k = e.getKey();
            NodeProjection v = e.getValue();
            this.nodeProjectionsWithIdentifier.put(Objects.requireNonNull(k, "nodeProjectionsWithIdentifier key"), Objects.requireNonNull(v, "nodeProjectionsWithIdentifier value"));
        }
        return this;
    }

    public final StoreLoaderBuilder putRelationshipProjectionsWithIdentifier(String key, RelationshipProjection value) {
        this.relationshipProjectionsWithIdentifier.put(Objects.requireNonNull(key, "relationshipProjectionsWithIdentifier key"), Objects.requireNonNull(value, "relationshipProjectionsWithIdentifier value"));
        return this;
    }

    public final StoreLoaderBuilder putRelationshipProjectionsWithIdentifier(Map.Entry<String, ? extends RelationshipProjection> entry) {
        String k = entry.getKey();
        RelationshipProjection v = entry.getValue();
        this.relationshipProjectionsWithIdentifier.put(Objects.requireNonNull(k, "relationshipProjectionsWithIdentifier key"), Objects.requireNonNull(v, "relationshipProjectionsWithIdentifier value"));
        return this;
    }

    public final StoreLoaderBuilder relationshipProjectionsWithIdentifier(Map<String, ? extends RelationshipProjection> entries) {
        this.relationshipProjectionsWithIdentifier.clear();
        return this.putAllRelationshipProjectionsWithIdentifier(entries);
    }

    public final StoreLoaderBuilder putAllRelationshipProjectionsWithIdentifier(Map<String, ? extends RelationshipProjection> entries) {
        for (Map.Entry<String, ? extends RelationshipProjection> e : entries.entrySet()) {
            String k = e.getKey();
            RelationshipProjection v = e.getValue();
            this.relationshipProjectionsWithIdentifier.put(Objects.requireNonNull(k, "relationshipProjectionsWithIdentifier key"), Objects.requireNonNull(v, "relationshipProjectionsWithIdentifier value"));
        }
        return this;
    }

    public final StoreLoaderBuilder addNodeProperty(PropertyMapping element) {
        element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
        this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
        return this;
    }

    public final StoreLoaderBuilder addNodeProperty(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        return this.addNodeProperty(ImmutablePropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
    }

    public final StoreLoaderBuilder addNodeProperties(PropertyMapping ... elements) {
        for (PropertyMapping element : elements) {
            element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
            this.nodeProperties.add(Objects.requireNonNull(element, "nodeProperties element"));
        }
        return this;
    }

    public final StoreLoaderBuilder nodeProperties(Iterable<? extends PropertyMapping> elements) {
        this.nodeProperties.clear();
        return this.addAllNodeProperties(elements);
    }

    public final StoreLoaderBuilder addAllNodeProperties(Iterable<? extends PropertyMapping> elements) {
        for (PropertyMapping propertyMapping : elements) {
            PropertyMapping propertyMapping2 = ImmutablePropertyMapping.copyOf((PropertyMapping)propertyMapping);
            this.nodeProperties.add(Objects.requireNonNull(propertyMapping2, "nodeProperties element"));
        }
        return this;
    }

    public final StoreLoaderBuilder addRelationshipProperty(PropertyMapping element) {
        element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
        this.relationshipProperties.add(Objects.requireNonNull(element, "relationshipProperties element"));
        return this;
    }

    public final StoreLoaderBuilder addRelationshipProperty(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        return this.addRelationshipProperty(ImmutablePropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
    }

    public final StoreLoaderBuilder addRelationshipProperties(PropertyMapping ... elements) {
        for (PropertyMapping element : elements) {
            element = ImmutablePropertyMapping.copyOf((PropertyMapping)element);
            this.relationshipProperties.add(Objects.requireNonNull(element, "relationshipProperties element"));
        }
        return this;
    }

    public final StoreLoaderBuilder relationshipProperties(Iterable<? extends PropertyMapping> elements) {
        this.relationshipProperties.clear();
        return this.addAllRelationshipProperties(elements);
    }

    public final StoreLoaderBuilder addAllRelationshipProperties(Iterable<? extends PropertyMapping> elements) {
        for (PropertyMapping propertyMapping : elements) {
            PropertyMapping propertyMapping2 = ImmutablePropertyMapping.copyOf((PropertyMapping)propertyMapping);
            this.relationshipProperties.add(Objects.requireNonNull(propertyMapping2, "relationshipProperties element"));
        }
        return this;
    }

    public final StoreLoaderBuilder concurrency(int concurrency) {
        this.concurrency = Optional.of(concurrency);
        return this;
    }

    public final StoreLoaderBuilder concurrency(Optional<Integer> concurrency) {
        this.concurrency = Objects.requireNonNull(concurrency, "concurrency");
        return this;
    }

    public final StoreLoaderBuilder globalOrientation(Orientation globalOrientation) {
        this.globalOrientation = Optional.of(globalOrientation);
        return this;
    }

    public final StoreLoaderBuilder globalOrientation(Optional<? extends Orientation> globalOrientation) {
        this.globalOrientation = Objects.requireNonNull(globalOrientation, "globalOrientation");
        return this;
    }

    public final StoreLoaderBuilder globalAggregation(Aggregation globalAggregation) {
        this.globalAggregation = Optional.of(globalAggregation);
        return this;
    }

    public final StoreLoaderBuilder globalAggregation(Optional<? extends Aggregation> globalAggregation) {
        this.globalAggregation = Objects.requireNonNull(globalAggregation, "globalAggregation");
        return this;
    }

    public final StoreLoaderBuilder validateRelationships(boolean validateRelationships) {
        this.validateRelationships = Optional.of(validateRelationships);
        return this;
    }

    public final StoreLoaderBuilder validateRelationships(Optional<Boolean> validateRelationships) {
        this.validateRelationships = Objects.requireNonNull(validateRelationships, "validateRelationships");
        return this;
    }

    public GraphLoader build() {
        this.checkRequiredAttributes();
        return GraphLoaderBuilders.storeLoader(this.api, this.transactionContext, this.executorService, this.terminationFlag, this.log, this.userName, this.graphName, StoreLoaderBuilder.createUnmodifiableList(true, this.nodeLabels), StoreLoaderBuilder.createUnmodifiableList(true, this.relationshipTypes), StoreLoaderBuilder.createUnmodifiableList(true, this.nodeProjections), StoreLoaderBuilder.createUnmodifiableList(true, this.relationshipProjections), StoreLoaderBuilder.createUnmodifiableMap(false, false, this.nodeProjectionsWithIdentifier), StoreLoaderBuilder.createUnmodifiableMap(false, false, this.relationshipProjectionsWithIdentifier), StoreLoaderBuilder.createUnmodifiableList(true, this.nodeProperties), StoreLoaderBuilder.createUnmodifiableList(true, this.relationshipProperties), this.concurrency, this.globalOrientation, this.globalAggregation, this.validateRelationships);
    }

    private boolean apiIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.apiIsSet()) {
            attributes.add("api");
        }
        return "Cannot build storeLoader, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

