/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.immutables.value.Generated;
import org.neo4j.gds.GraphLoaderBuilders;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.config.ImmutableGraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphLoader;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

@Generated(from="GraphLoaderBuilders.storeLoaderWithConfig", generator="Immutables")
public final class StoreLoaderWithConfigBuilder {
    private static final long INIT_BIT_API = 1L;
    private static final long INIT_BIT_GRAPH_PROJECT_CONFIG = 2L;
    private long initBits = 3L;
    private GraphDatabaseAPI api;
    private Optional<TransactionContext> transactionContext = Optional.empty();
    private Optional<ExecutorService> executorService = Optional.empty();
    private Optional<TerminationFlag> terminationFlag = Optional.empty();
    private Optional<Log> log = Optional.empty();
    private Optional<String> userName = Optional.empty();
    private GraphProjectFromStoreConfig graphProjectConfig;

    public final StoreLoaderWithConfigBuilder api(GraphDatabaseAPI api) {
        this.api = Objects.requireNonNull(api, "api");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final StoreLoaderWithConfigBuilder transactionContext(TransactionContext transactionContext) {
        this.transactionContext = Optional.of(transactionContext);
        return this;
    }

    public final StoreLoaderWithConfigBuilder transactionContext(Optional<? extends TransactionContext> transactionContext) {
        this.transactionContext = Objects.requireNonNull(transactionContext, "transactionContext");
        return this;
    }

    public final StoreLoaderWithConfigBuilder executorService(ExecutorService executorService) {
        this.executorService = Optional.of(executorService);
        return this;
    }

    public final StoreLoaderWithConfigBuilder executorService(Optional<? extends ExecutorService> executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        return this;
    }

    public final StoreLoaderWithConfigBuilder terminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = Optional.of(terminationFlag);
        return this;
    }

    public final StoreLoaderWithConfigBuilder terminationFlag(Optional<? extends TerminationFlag> terminationFlag) {
        this.terminationFlag = Objects.requireNonNull(terminationFlag, "terminationFlag");
        return this;
    }

    public final StoreLoaderWithConfigBuilder log(Log log) {
        this.log = Optional.of(log);
        return this;
    }

    public final StoreLoaderWithConfigBuilder log(Optional<? extends Log> log) {
        this.log = Objects.requireNonNull(log, "log");
        return this;
    }

    public final StoreLoaderWithConfigBuilder userName(String userName) {
        this.userName = Optional.of(userName);
        return this;
    }

    public final StoreLoaderWithConfigBuilder userName(Optional<String> userName) {
        this.userName = Objects.requireNonNull(userName, "userName");
        return this;
    }

    public final StoreLoaderWithConfigBuilder graphProjectConfig(String username, String graphName, NodeProjections nodeProjections, RelationshipProjections relationshipProjections) {
        return this.graphProjectConfig(ImmutableGraphProjectFromStoreConfig.of((String)username, (String)graphName, (NodeProjections)nodeProjections, (RelationshipProjections)relationshipProjections));
    }

    public final StoreLoaderWithConfigBuilder graphProjectConfig(GraphProjectFromStoreConfig graphProjectConfig) {
        this.graphProjectConfig = ImmutableGraphProjectFromStoreConfig.copyOf((GraphProjectFromStoreConfig)graphProjectConfig);
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public GraphLoader build() {
        this.checkRequiredAttributes();
        return GraphLoaderBuilders.storeLoaderWithConfig(this.api, this.transactionContext, this.executorService, this.terminationFlag, this.log, this.userName, ImmutableGraphProjectFromStoreConfig.copyOf((GraphProjectFromStoreConfig)this.graphProjectConfig));
    }

    private boolean apiIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean graphProjectConfigIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.apiIsSet()) {
            attributes.add("api");
        }
        if (!this.graphProjectConfigIsSet()) {
            attributes.add("graphProjectConfig");
        }
        return "Cannot build storeLoaderWithConfig, some of required attributes are not set " + attributes;
    }
}

