/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.gds.CypherLoaderBuilder;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.TestGraphLoader;
import org.neo4j.gds.TestSupport;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.GraphLoader;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public final class TestCypherGraphLoader
implements TestGraphLoader {
    private final GraphDatabaseAPI db;
    private final Set<String> nodeLabels;
    private final Set<String> relTypes;
    private PropertyMappings nodeProperties = PropertyMappings.of();
    private PropertyMappings relProperties = PropertyMappings.of();
    private Optional<Aggregation> maybeAggregation = Optional.empty();
    private Optional<Log> maybeLog = Optional.empty();
    private static final String SUFFIX = "___";

    TestCypherGraphLoader(GraphDatabaseAPI db) {
        this.db = db;
        this.nodeLabels = new HashSet<String>();
        this.relTypes = new HashSet<String>();
    }

    @Override
    public TestCypherGraphLoader withLabels(String ... labels) {
        this.nodeLabels.addAll(Arrays.asList(labels));
        return this;
    }

    @Override
    public TestCypherGraphLoader withRelationshipTypes(String ... types) {
        this.relTypes.addAll(Arrays.asList(types));
        return this;
    }

    @Override
    public TestCypherGraphLoader withNodeProperties(PropertyMappings nodeProperties) {
        this.nodeProperties = nodeProperties;
        return this;
    }

    @Override
    public TestCypherGraphLoader withRelationshipProperties(PropertyMapping ... relProperties) {
        return this.withRelationshipProperties(PropertyMappings.of((PropertyMapping[])relProperties));
    }

    @Override
    public TestCypherGraphLoader withRelationshipProperties(PropertyMappings relProperties) {
        return this.withRelationshipProperties(relProperties, true);
    }

    @Override
    public TestCypherGraphLoader withRelationshipProperties(PropertyMappings relProperties, boolean addToLoader) {
        this.relProperties = relProperties;
        return this;
    }

    @Override
    public TestCypherGraphLoader withDefaultAggregation(Aggregation aggregation) {
        this.maybeAggregation = Optional.of(aggregation);
        return this;
    }

    @Override
    public TestCypherGraphLoader withLog(Log log) {
        this.maybeLog = Optional.of(log);
        return this;
    }

    @Override
    public Graph graph() {
        return this.graphStore().getUnion();
    }

    @Override
    public GraphStore graphStore() {
        try (Transaction ignored = this.db.beginTx();){
            GraphStore graphStore = this.cypherLoader().graphStore();
            return graphStore;
        }
    }

    private GraphLoader cypherLoader() {
        CypherLoaderBuilder cypherLoaderBuilder = new CypherLoaderBuilder().api(this.db);
        String nodeQueryTemplate = "MATCH (n) %s RETURN id(n) AS id%s%s";
        String labelString = this.nodeLabels.isEmpty() ? "" : this.nodeLabels.stream().map(l -> "n:" + l).collect(Collectors.joining(" OR ", "WHERE ", ""));
        String nodePropertiesString = this.getNodePropertiesString(this.nodeProperties, "n");
        cypherLoaderBuilder.nodeQuery(StringFormatting.formatWithLocale((String)nodeQueryTemplate, (Object[])new Object[]{labelString, this.nodeLabels.isEmpty() ? "" : ", labels(n) AS labels", nodePropertiesString}));
        Object relationshipQueryTemplate = "MATCH (n)-[r%s]->(m) RETURN ";
        if (!Arrays.asList(Aggregation.DEFAULT, Aggregation.NONE).contains(this.maybeAggregation.orElse(Aggregation.NONE))) {
            relationshipQueryTemplate = (String)relationshipQueryTemplate + "DISTINCT ";
        }
        relationshipQueryTemplate = (String)relationshipQueryTemplate + (this.relTypes.isEmpty() ? " id(n) AS source, id(m) AS target%s" : " type(r) AS type, id(n) AS source, id(m) AS target%s");
        String relTypeString = this.relTypes.isEmpty() ? "" : StringJoining.join(this.relTypes, (CharSequence)"|", (CharSequence)":", (CharSequence)"");
        this.relProperties = this.getUniquePropertyMappings(this.relProperties);
        String relPropertiesString = this.getRelationshipPropertiesString(this.relProperties, "r");
        cypherLoaderBuilder.relationshipQuery(StringFormatting.formatWithLocale((String)relationshipQueryTemplate, (Object[])new Object[]{relTypeString, relPropertiesString}));
        cypherLoaderBuilder.validateRelationships(false);
        cypherLoaderBuilder.log(this.maybeLog);
        return cypherLoaderBuilder.build();
    }

    private PropertyMappings getUniquePropertyMappings(PropertyMappings propertyMappings) {
        MutableInt mutableInt = new MutableInt(0);
        return PropertyMappings.of((PropertyMapping[])((PropertyMapping[])propertyMappings.stream().map(mapping -> PropertyMapping.of((String)mapping.propertyKey(), (String)TestCypherGraphLoader.addSuffix(mapping.neoPropertyKey(), mutableInt.getAndIncrement()), (DefaultValue)mapping.defaultValue(), (Aggregation)(mapping.aggregation() == Aggregation.DEFAULT ? this.maybeAggregation.orElse(Aggregation.NONE) : mapping.aggregation()))).toArray(PropertyMapping[]::new)));
    }

    private String getNodePropertiesString(PropertyMappings propertyMappings, String entityVar) {
        return propertyMappings.hasMappings() ? propertyMappings.stream().map(mapping -> StringFormatting.formatWithLocale((String)"COALESCE(%s.%s, %s) AS %s", (Object[])new Object[]{entityVar, mapping.neoPropertyKey(), mapping.defaultValue().getObject(), mapping.propertyKey()})).collect(Collectors.joining(", ", ", ", "")) : "";
    }

    private String getRelationshipPropertiesString(PropertyMappings propertyMappings, String entityVar) {
        return propertyMappings.hasMappings() ? propertyMappings.stream().map(mapping -> StringFormatting.formatWithLocale((String)"%s AS %s", (Object[])new Object[]{TestSupport.getCypherAggregation(mapping.aggregation().name(), StringFormatting.formatWithLocale((String)"COALESCE(%s.%s, %f)", (Object[])new Object[]{entityVar, this.removeSuffix(mapping.neoPropertyKey()), mapping.defaultValue().getObject()})), mapping.propertyKey()})).collect(Collectors.joining(", ", ", ", "")) : "";
    }

    private static String addSuffix(String propertyKey, int id) {
        return StringFormatting.formatWithLocale((String)"%s%s%d", (Object[])new Object[]{propertyKey, SUFFIX, id});
    }

    private String removeSuffix(String propertyKey) {
        return propertyKey.substring(0, propertyKey.indexOf(SUFFIX));
    }
}

