/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.StoreLoaderBuilder;
import org.neo4j.gds.TestGraphLoader;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.GraphLoader;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;

public final class TestNativeGraphLoader
implements TestGraphLoader {
    private final GraphDatabaseAPI db;
    private final Set<String> nodeLabels;
    private final Set<String> relTypes;
    private PropertyMappings nodeProperties = PropertyMappings.of();
    private PropertyMappings relProperties = PropertyMappings.of();
    private boolean addRelationshipPropertiesToLoader;
    private Optional<Aggregation> maybeAggregation = Optional.empty();
    private Optional<Log> maybeLog = Optional.empty();

    TestNativeGraphLoader(GraphDatabaseAPI db) {
        this.db = db;
        this.nodeLabels = new HashSet<String>();
        this.relTypes = new HashSet<String>();
    }

    @Override
    public TestNativeGraphLoader withLabels(String ... labels) {
        this.nodeLabels.addAll(Arrays.asList(labels));
        return this;
    }

    @Override
    public TestNativeGraphLoader withRelationshipTypes(String ... types) {
        this.relTypes.addAll(Arrays.asList(types));
        return this;
    }

    @Override
    public TestNativeGraphLoader withNodeProperties(PropertyMappings nodeProperties) {
        this.nodeProperties = nodeProperties;
        return this;
    }

    @Override
    public TestNativeGraphLoader withRelationshipProperties(PropertyMapping ... relProperties) {
        return this.withRelationshipProperties(PropertyMappings.of((PropertyMapping[])relProperties));
    }

    @Override
    public TestNativeGraphLoader withRelationshipProperties(PropertyMappings relProperties) {
        return this.withRelationshipProperties(relProperties, true);
    }

    @Override
    public TestNativeGraphLoader withRelationshipProperties(PropertyMappings relProperties, boolean addToLoader) {
        this.relProperties = relProperties;
        this.addRelationshipPropertiesToLoader = addToLoader;
        return this;
    }

    @Override
    public TestNativeGraphLoader withDefaultAggregation(Aggregation aggregation) {
        this.maybeAggregation = Optional.of(aggregation);
        return this;
    }

    @Override
    public TestNativeGraphLoader withLog(Log log) {
        this.maybeLog = Optional.of(log);
        return this;
    }

    @Override
    public Graph graph() {
        return this.graphStore().getUnion();
    }

    @Override
    public GraphStore graphStore() {
        try (Transaction ignored = this.db.beginTx();){
            GraphStore graphStore = this.storeLoader().graphStore();
            return graphStore;
        }
    }

    private GraphLoader storeLoader() {
        StoreLoaderBuilder storeLoaderBuilder = new StoreLoaderBuilder().api(this.db);
        this.nodeLabels.forEach(storeLoaderBuilder::addNodeLabel);
        if (this.relTypes.isEmpty()) {
            storeLoaderBuilder.putRelationshipProjectionsWithIdentifier(RelationshipType.ALL_RELATIONSHIPS.name, RelationshipProjection.all().withAggregation(this.maybeAggregation.orElse(Aggregation.DEFAULT)));
        } else {
            this.relTypes.forEach(relType -> {
                RelationshipProjection template = RelationshipProjection.builder().type(relType).aggregation(this.maybeAggregation.orElse(Aggregation.DEFAULT)).build();
                storeLoaderBuilder.addRelationshipProjection(template.withOrientation(Orientation.NATURAL));
            });
        }
        storeLoaderBuilder.globalAggregation(this.maybeAggregation.orElse(Aggregation.DEFAULT));
        if (!this.nodeProperties.mappings().isEmpty()) {
            storeLoaderBuilder.nodeProperties((Iterable<? extends PropertyMapping>)this.nodeProperties);
        }
        if (this.addRelationshipPropertiesToLoader) {
            storeLoaderBuilder.relationshipProperties((Iterable<? extends PropertyMapping>)this.relProperties);
        }
        storeLoaderBuilder.log(this.maybeLog);
        return storeLoaderBuilder.build();
    }
}

