/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.logging.Log;

public class TestProgressTracker
extends TaskProgressTracker {
    private final List<AtomicLong> progresses = new ArrayList<AtomicLong>();

    public TestProgressTracker(Task baseTask, Log log, int concurrency, TaskRegistryFactory taskRegistryFactory) {
        super(baseTask, log, concurrency, taskRegistryFactory);
    }

    public List<AtomicLong> getProgresses() {
        return this.progresses;
    }

    public void logProgress(long progress) {
        this.progresses.get(this.progresses.size() - 1).addAndGet(progress);
        super.logProgress(progress);
    }

    public void beginSubTask() {
        super.beginSubTask();
        this.currentTask.ifPresent(__ -> this.progresses.add(new AtomicLong()));
    }

    public void setVolume(long volume) {
        super.setVolume(volume);
        this.progresses.add(new AtomicLong());
    }
}

