/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.hamcrest.Matcher;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.provider.Arguments;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.QueryRunner;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.canonization.CanonicalAdjacencyMatrix;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.extension.GdlSupportExtension;
import org.neo4j.gds.extension.IdFunction;
import org.neo4j.gds.extension.TestGraph;
import org.neo4j.gds.gdl.GdlFactory;
import org.neo4j.gds.gdl.GraphProjectFromGdlConfig;
import org.neo4j.gds.gdl.ImmutableGraphProjectFromGdlConfig;
import org.neo4j.gds.transaction.TransactionContext;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public final class TestSupport {
    private TestSupport() {
    }

    public static Stream<Orientation> allDirectedProjections() {
        return Stream.of(Orientation.NATURAL, Orientation.REVERSE);
    }

    public static <T> Supplier<Stream<Arguments>> toArguments(Supplier<Stream<T>> fn) {
        return () -> ((Stream)fn.get()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    public static <T> Supplier<Stream<Arguments>> toArgumentsFlat(Supplier<Stream<List<T>>> fn) {
        return () -> ((Stream)fn.get()).map(List::toArray).map(Arguments::of);
    }

    @SafeVarargs
    public static Stream<Arguments> crossArguments(Supplier<Stream<Arguments>> firstFn, Supplier<Stream<Arguments>> ... otherFns) {
        return Arrays.stream(otherFns).reduce(firstFn, (l, r) -> () -> TestSupport.lambda$crossArguments$3((Supplier)l, (Supplier)r)).get();
    }

    public static Stream<Arguments> crossArguments(Supplier<Stream<Arguments>> leftFn, Supplier<Stream<Arguments>> rightFn) {
        return leftFn.get().flatMap(leftArgs -> ((Stream)rightFn.get()).map(rightArgs -> {
            ArrayList<Object> leftObjects = new ArrayList<Object>(Arrays.asList(leftArgs.get()));
            leftObjects.addAll(new ArrayList<Object>(Arrays.asList(rightArgs.get())));
            return Arguments.of((Object[])leftObjects.toArray());
        }));
    }

    public static Stream<Arguments> trueFalseArguments() {
        return Stream.of(true, false).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    public static TestGraph fromGdl(String gdl) {
        return TestSupport.fromGdl(gdl, Orientation.NATURAL, "graph");
    }

    public static TestGraph fromGdl(String gdl, String name) {
        return TestSupport.fromGdl(gdl, Orientation.NATURAL, name);
    }

    public static TestGraph fromGdl(String gdl, Orientation orientation) {
        return TestSupport.fromGdl(gdl, orientation, "graph");
    }

    public static TestGraph fromGdl(String gdl, Orientation orientation, String name) {
        Objects.requireNonNull(gdl);
        GraphProjectFromGdlConfig config = ImmutableGraphProjectFromGdlConfig.builder().gdlGraph(gdl).graphName("graph").orientation(orientation).build();
        GdlFactory gdlFactory = GdlFactory.builder().graphProjectConfig(config).namedDatabaseId(GdlSupportExtension.DATABASE_ID).build();
        return new TestGraph(gdlFactory.build().getUnion(), gdlFactory::nodeId, name);
    }

    public static GraphStore graphStoreFromGDL(String gdl) {
        Objects.requireNonNull(gdl);
        return GdlFactory.of(gdl).build();
    }

    public static long[][] ids(IdFunction idFunction, String[][] variables) {
        return (long[][])Arrays.stream(variables).map(vs -> TestSupport.ids(idFunction, vs)).toArray(x$0 -> new long[x$0][]);
    }

    public static long[] ids(IdFunction idFunction, String ... variables) {
        return Arrays.stream(variables).mapToLong(arg_0 -> ((IdFunction)idFunction).of(arg_0)).toArray();
    }

    public static void assertLongValues(TestGraph graph, Function<Long, Long> actualValues, Map<String, Long> expectedValues) {
        expectedValues.forEach((variable, expectedValue) -> {
            Long actualValue = (Long)actualValues.apply(graph.toMappedNodeId((String)variable));
            org.junit.jupiter.api.Assertions.assertEquals((Long)expectedValue, (Long)actualValue, (String)StringFormatting.formatWithLocale((String)"Values do not match for variable %s. Expected %s, got %s.", (Object[])new Object[]{variable, expectedValue.toString(), actualValue.toString()}));
        });
    }

    public static void assertDoubleValues(TestGraph graph, Function<Long, Double> actualValues, Map<String, Double> expectedValues, double delta) {
        expectedValues.forEach((variable, expectedValue) -> {
            Double actualValue = (Double)actualValues.apply(graph.toMappedNodeId((String)variable));
            org.junit.jupiter.api.Assertions.assertEquals((double)expectedValue, (double)actualValue, (double)delta, (String)StringFormatting.formatWithLocale((String)"Values do not match for variable %s. Expected %s, got %s.", (Object[])new Object[]{variable, expectedValue.toString(), actualValue.toString()}));
        });
    }

    public static void assertGraphEquals(Graph expected, Graph actual) {
        org.junit.jupiter.api.Assertions.assertEquals((long)expected.nodeCount(), (long)actual.nodeCount(), (String)"Node counts do not match.");
        org.junit.jupiter.api.Assertions.assertEquals((Object)CanonicalAdjacencyMatrix.canonicalize(expected), (Object)CanonicalAdjacencyMatrix.canonicalize(actual));
    }

    public static void assertGraphEquals(Collection<Graph> expectedGraphs, Graph actual) {
        List expectedCanonicalized = expectedGraphs.stream().map(CanonicalAdjacencyMatrix::canonicalize).collect(Collectors.toList());
        String actualCanonicalized = CanonicalAdjacencyMatrix.canonicalize(actual);
        boolean equals = expectedCanonicalized.stream().map(expected -> expected.equals(actualCanonicalized)).reduce(Boolean::logicalXor).orElse(false);
        String message = StringFormatting.formatWithLocale((String)"None of the given graphs matches the actual one.%nActual:%n%s%nExpected:%n%s", (Object[])new Object[]{actualCanonicalized, String.join((CharSequence)"\n\n", expectedCanonicalized)});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)equals, (String)message);
    }

    public static void assertMemoryEstimation(Supplier<MemoryEstimation> actualMemoryEstimation, long nodeCount, int concurrency, long expectedMinBytes, long expectedMaxBytes) {
        TestSupport.assertMemoryEstimation(actualMemoryEstimation, nodeCount, 0L, concurrency, expectedMinBytes, expectedMaxBytes);
    }

    public static void assertMemoryEstimation(Supplier<MemoryEstimation> actualMemoryEstimation, long nodeCount, long relationshipCount, int concurrency, long expectedMinBytes, long expectedMaxBytes) {
        TestSupport.assertMemoryEstimation(actualMemoryEstimation, GraphDimensions.of((long)nodeCount, (long)relationshipCount), concurrency, expectedMinBytes, expectedMaxBytes);
    }

    public static void assertMemoryEstimation(Supplier<MemoryEstimation> actualMemoryEstimation, GraphDimensions dimensions, int concurrency, long expectedMinBytes, long expectedMaxBytes) {
        MemoryRange actual = actualMemoryEstimation.get().estimate(dimensions, concurrency).memoryUsage();
        SoftAssertions softly = new SoftAssertions();
        softly.assertThat(actual.min).isEqualTo(expectedMinBytes);
        softly.assertThat(actual.max).isEqualTo(expectedMaxBytes);
        softly.assertAll();
    }

    public static void assertTransactionTermination(Executable executable) {
        TransactionTerminatedException exception = (TransactionTerminatedException)org.junit.jupiter.api.Assertions.assertThrows(TransactionTerminatedException.class, (Executable)executable);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Status.Transaction.Terminated, (Object)exception.status());
    }

    public static void assertCypherResult(GraphDatabaseService db, @Language(value="Cypher") String query, List<Map<String, Object>> expected) {
        TestSupport.assertCypherResult(db, query, Collections.emptyMap(), expected);
    }

    public static void assertCypherResult(GraphDatabaseService db, @Language(value="Cypher") String query, Map<String, Object> queryParameters, List<Map<String, Object>> expected) {
        GraphDatabaseApiProxy.runInTransaction((GraphDatabaseService)db, tx -> {
            SoftAssertions softAssertions = new SoftAssertions();
            ArrayList actual = new ArrayList();
            QueryRunner.runQueryWithResultConsumer(db, query, queryParameters, result -> result.accept(row -> {
                HashMap<String, Object> _row = new HashMap<String, Object>();
                for (String column : result.columns()) {
                    _row.put(column, row.get(column));
                }
                actual.add(_row);
                return true;
            }));
            ((ListAssert)Assertions.assertThat(actual).withFailMessage("Different amount of rows returned for actual result (%d) than expected (%d)", new Object[]{actual.size(), expected.size()})).hasSize(expected.size());
            int i = 0;
            while (i < expected.size()) {
                Map expectedRow = (Map)expected.get(i);
                Map actualRow = (Map)actual.get(i);
                softAssertions.assertThat(actualRow.keySet()).containsExactlyInAnyOrderElementsOf(expectedRow.keySet());
                int rowNumber = i++;
                expectedRow.forEach((key, expectedValue) -> {
                    Object actualValue = actualRow.get(key);
                    ObjectAssert assertion = (ObjectAssert)softAssertions.assertThat(actualValue).withFailMessage("Different value for column '%s' of row %d (expected %s, but got %s)", new Object[]{key, rowNumber, expectedValue, actualValue});
                    if (expectedValue instanceof Matcher) {
                        assertion.is((Condition)new HamcrestCondition((Matcher)expectedValue));
                    } else if (expectedValue instanceof Condition) {
                        assertion.is((Condition)expectedValue);
                    } else {
                        assertion.isEqualTo(expectedValue);
                    }
                });
            }
            softAssertions.assertAll();
        });
    }

    public static String getCypherAggregation(String aggregation, String property) {
        String cypherAggregation;
        switch (Aggregation.parse((Object)aggregation)) {
            case SINGLE: {
                cypherAggregation = "head(collect(%s))";
                break;
            }
            case SUM: {
                cypherAggregation = "sum(%s)";
                break;
            }
            case MIN: {
                cypherAggregation = "min(%s)";
                break;
            }
            case MAX: {
                cypherAggregation = "max(%s)";
                break;
            }
            case COUNT: {
                cypherAggregation = "count(%s)";
                break;
            }
            default: {
                cypherAggregation = "%s";
            }
        }
        return StringFormatting.formatWithLocale((String)cypherAggregation, (Object[])new Object[]{property});
    }

    public static TransactionContext fullAccessTransaction(GraphDatabaseAPI api) {
        return TransactionContext.of((GraphDatabaseAPI)api, (SecurityContext)SecurityContext.AUTH_DISABLED);
    }

    public static IdMap idMap(long nodeCount) {
        NodesBuilder builder = GraphFactory.initNodesBuilder().nodeCount(nodeCount).maxOriginalId(nodeCount - 1L).build();
        for (long i = 0L; i < nodeCount; ++i) {
            builder.addNode(i);
        }
        return builder.build().idMap();
    }

    public static IdMap idMap(long[] originalIds) {
        NodesBuilder builder = GraphFactory.initNodesBuilder().nodeCount((long)originalIds.length).maxOriginalId(Arrays.stream(originalIds).max().orElse(0L)).build();
        Arrays.stream(originalIds).forEach(arg_0 -> ((NodesBuilder)builder).addNode(arg_0));
        return builder.build().idMap();
    }

    private static /* synthetic */ Stream lambda$crossArguments$3(Supplier l, Supplier r) {
        return TestSupport.crossArguments((Supplier<Stream<Arguments>>)l, (Supplier<Stream<Arguments>>)r);
    }
}

