/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.gds.core.ExceptionMessageMatcher;
import org.neo4j.gds.utils.ExceptionUtil;

public class ThrowableRootCauseMatcher<T extends Throwable>
extends TypeSafeMatcher<T> {
    private final Matcher<? extends Throwable> causeMatcher;

    public ThrowableRootCauseMatcher(Matcher<? extends Throwable> causeMatcher) {
        this.causeMatcher = causeMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("exception with root cause ");
        description.appendDescriptionOf(this.causeMatcher);
    }

    protected boolean matchesSafely(T item) {
        Throwable rootCause = ExceptionUtil.rootCause(item);
        return this.causeMatcher.matches((Object)rootCause);
    }

    protected void describeMismatchSafely(T item, Description description) {
        description.appendText("cause ");
        Throwable rootCause = ExceptionUtil.rootCause(item);
        this.causeMatcher.describeMismatch((Object)rootCause, description);
    }

    public static <T extends Throwable> Matcher<T> rootCause(Matcher<? extends Throwable> matcher) {
        return new ThrowableRootCauseMatcher<T>(matcher);
    }

    public static <T extends Throwable> Matcher<T> rootCause(Class<? extends Throwable> type) {
        return ThrowableRootCauseMatcher.rootCause((Matcher<? extends Throwable>)CoreMatchers.instanceOf(type));
    }

    public static <T extends Throwable> Matcher<T> rootCause(Class<? extends Throwable> type, String message) {
        return ThrowableRootCauseMatcher.rootCause((Matcher<? extends Throwable>)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(type), ExceptionMessageMatcher.exceptionMessage((String)message)}));
    }
}

