/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.assertj;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.InstanceOfAssertFactory;
import org.assertj.core.api.MapAssert;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;

public final class AssertionsHelper {
    private AssertionsHelper() {
    }

    public static InstanceOfAssertFactory<Map, MapAssert<String, Object>> stringObjectMapAssertFactory() {
        return InstanceOfAssertFactories.map(String.class, Object.class);
    }

    public static Consumer<Object> booleanAssertConsumer(Consumer<AbstractBooleanAssert<?>> assertion) {
        return actualValue -> assertion.accept((AbstractBooleanAssert)Assertions.assertThat((Object)actualValue).asInstanceOf(InstanceOfAssertFactories.BOOLEAN));
    }

    public static Consumer<Object> creationTimeAssertConsumer() {
        return creationTime -> Assertions.assertThat((Object)creationTime).isInstanceOf(ZonedDateTime.class);
    }

    public static Consumer<Object> intAssertConsumer(Consumer<AbstractIntegerAssert<?>> assertion) {
        return actualValue -> assertion.accept((AbstractIntegerAssert)Assertions.assertThat((Object)actualValue).asInstanceOf(InstanceOfAssertFactories.INTEGER));
    }

    public static Consumer<Object> longAssertConsumer(Consumer<AbstractLongAssert<?>> assertion) {
        return actualValue -> assertion.accept((AbstractLongAssert)Assertions.assertThat((Object)actualValue).asInstanceOf(InstanceOfAssertFactories.LONG));
    }

    public static Consumer<Object> stringAssertConsumer(Consumer<AbstractStringAssert<?>> assertion) {
        return actualValue -> assertion.accept((AbstractStringAssert)Assertions.assertThat((Object)actualValue).asInstanceOf(InstanceOfAssertFactories.STRING));
    }

    public static Consumer<Object> listAssertConsumer(Consumer<AbstractListAssert> assertion) {
        return actualValue -> assertion.accept(Assertions.assertThat((Object)actualValue).asList());
    }

    public static Matcher<Map<? extends String, ?>> hasEntry(String key, Object value) {
        return IsMapContaining.hasEntry((Matcher)Matchers.equalTo((Object)key), (Matcher)Matchers.equalTo((Object)value));
    }
}

