/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.canonization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public final class CanonicalAdjacencyMatrix {
    private CanonicalAdjacencyMatrix() {
    }

    public static String canonicalize(Graph g) {
        HashMap canonicalLabels = new HashMap();
        g.forEachNode(nodeId -> {
            String sortedLabels = g.nodeLabels(nodeId).stream().filter(Predicate.not(arg_0 -> ((NodeLabel)NodeLabel.ALL_NODES).equals(arg_0))).map(ElementIdentifier::name).sorted().collect(Collectors.joining(":"));
            String sortedProperties = g.nodeLabels(nodeId).stream().flatMap(label -> ((Map)g.schema().nodeSchema().properties().get(label)).keySet().stream()).distinct().map(propertyKey -> {
                NodeProperties nodeProperties = g.nodeProperties(propertyKey);
                switch (nodeProperties.valueType()) {
                    case DOUBLE: {
                        return StringFormatting.formatWithLocale((String)"%s: %f", (Object[])new Object[]{propertyKey, nodeProperties.doubleValue(nodeId)});
                    }
                    case LONG: {
                        return StringFormatting.formatWithLocale((String)"%s: %d", (Object[])new Object[]{propertyKey, nodeProperties.longValue(nodeId)});
                    }
                    case DOUBLE_ARRAY: {
                        return StringFormatting.formatWithLocale((String)"%s: %s", (Object[])new Object[]{propertyKey, Arrays.toString(nodeProperties.doubleArrayValue(nodeId))});
                    }
                    case LONG_ARRAY: {
                        return StringFormatting.formatWithLocale((String)"%s: %s", (Object[])new Object[]{propertyKey, Arrays.toString(nodeProperties.longArrayValue(nodeId))});
                    }
                    case FLOAT_ARRAY: {
                        return StringFormatting.formatWithLocale((String)"%s: %s", (Object[])new Object[]{propertyKey, Arrays.toString(nodeProperties.floatArrayValue(nodeId))});
                    }
                }
                throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unsupported type: %s", (Object[])new Object[]{nodeProperties.valueType()}));
            }).sorted().collect(Collectors.joining(", "));
            String canonicalNode = StringFormatting.formatWithLocale((String)"(%s%s)", (Object[])new Object[]{sortedLabels.isEmpty() ? "" : StringFormatting.formatWithLocale((String)":%s", (Object[])new Object[]{sortedLabels}), sortedProperties.isEmpty() ? "" : StringFormatting.formatWithLocale((String)" { %s }", (Object[])new Object[]{sortedProperties})});
            canonicalLabels.put(nodeId, canonicalNode);
            return true;
        });
        HashMap<Long, List<String>> outAdjacencies = new HashMap<Long, List<String>>();
        HashMap<Long, List<String>> inAdjacencies = new HashMap<Long, List<String>>();
        for (RelationshipType relationshipType : g.schema().relationshipSchema().availableTypes()) {
            Graph relTypeGraph = g.relationshipTypeFilteredGraph(Set.of(relationshipType));
            g.forEachNode(nodeId -> {
                g.forEachRelationship(nodeId, 1.0, (sourceId, targetId, propertyValue) -> {
                    outAdjacencies.compute(sourceId, CanonicalAdjacencyMatrix.canonicalRelationship((String)canonicalLabels.get(targetId), relationshipType.name(), propertyValue, "()-[:%s w: %f]->%s"));
                    inAdjacencies.compute(targetId, CanonicalAdjacencyMatrix.canonicalRelationship((String)canonicalLabels.get(sourceId), relationshipType.name(), propertyValue, "()<-[:%s w: %f]-%s"));
                    return true;
                });
                return true;
            });
        }
        Map<Long, String> canonicalOutAdjacencies = CanonicalAdjacencyMatrix.canonicalAdjacencies(outAdjacencies);
        Map<Long, String> canonicalInAdjacencies = CanonicalAdjacencyMatrix.canonicalAdjacencies(inAdjacencies);
        return canonicalLabels.entrySet().stream().map(entry -> StringFormatting.formatWithLocale((String)"%s => out: %s in: %s", (Object[])new Object[]{entry.getValue(), canonicalOutAdjacencies.getOrDefault(entry.getKey(), ""), canonicalInAdjacencies.getOrDefault(entry.getKey(), "")})).sorted().collect(Collectors.joining(System.lineSeparator()));
    }

    private static Map<Long, String> canonicalAdjacencies(Map<Long, List<String>> outAdjacencies) {
        return outAdjacencies.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> StringJoining.join((Collection)((Collection)entry.getValue()), (CharSequence)", ")));
    }

    private static BiFunction<Long, List<String>, List<String>> canonicalRelationship(String canonicalNodeLabel, String type, double relationshipProperty, String pattern) {
        return (unused, list) -> {
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(StringFormatting.formatWithLocale((String)pattern, (Object[])new Object[]{type, relationshipProperty, canonicalNodeLabel}));
            return list;
        };
    }
}

