/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.tuple.Tuples;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

public final class CypherExporter {
    public static void export(PrintWriter out, GraphDatabaseService db) {
        CypherExporter.export(out, db, NeoData.INSTANCE);
    }

    public static void export(PrintWriter out, Graph graph) {
        CypherExporter.export(out, graph, GraphData.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <G, NP, N extends NP, RP, R extends RP> void export(PrintWriter out, G graph, GraphLike<G, NP, N, RP, R> graphLike) {
        try {
            StringBuilder sb = new StringBuilder();
            NodeLike nodeLike = graphLike.nodeLike();
            RelationshipLike relLike = graphLike.relLike();
            PropertiesLike nodePropsLike = graphLike.nodePropsLike();
            PropertiesLike relPropsLike = graphLike.relPropsLike();
            graphLike.runInTx(graph, () -> {
                graphLike.forEachNode(graph, n -> CypherExporter.node(n, graph, nodeLike, nodePropsLike, sb).append(System.lineSeparator()));
                StringJoiner relStatements = new StringJoiner("," + System.lineSeparator(), "CREATE" + System.lineSeparator(), "");
                relStatements.setEmptyValue("");
                StringBuilder relBuilder = new StringBuilder();
                graphLike.forEachNode(graph, n -> graphLike.forEachOutgoing(graph, n, r -> {
                    relBuilder.setLength(0);
                    CypherExporter.rel(r, graph, relLike, relPropsLike, relBuilder);
                    relStatements.add(relBuilder);
                }));
                sb.append(relStatements).append(';');
            });
            sb.append(System.lineSeparator());
            out.println(sb);
        }
        finally {
            out.flush();
        }
    }

    private static <T, C> StringBuilder node(T item, C context, NodeLike<? super T> node, PropertiesLike<? super T, C> props, StringBuilder s) {
        s.append("CREATE (n").append(node.id(item));
        for (String label : node.labels(item)) {
            s.append(':').append(label);
        }
        return s.append(CypherExporter.props(item, context, props, s)).append(')');
    }

    private static <T, C> void rel(T item, C context, RelationshipLike<? super T> rel, PropertiesLike<? super T, C> props, StringBuilder s) {
        s.append("  (n").append(rel.startId(item)).append(")-[");
        rel.type(item).ifPresent(type -> s.append(':').append((String)type));
        s.append(CypherExporter.props(item, context, props, s)).append("]->").append("(n").append(rel.endId(item)).append(')');
    }

    private static <T, C> String props(T item, C context, PropertiesLike<T, C> props, StringBuilder s) {
        int length = s.length();
        s.append(" {");
        for (String propKey : props.availableKeys(item, context)) {
            Object propValue = props.property(propKey, item, context);
            s.append(propKey).append(':').append(propValue);
        }
        if (s.length() - 2 != length) {
            s.append('}');
        } else {
            s.setLength(length);
        }
        return "";
    }

    private CypherExporter() {
    }

    static enum GraphRel implements RelationshipLike<Pair<Long, Long>>,
    PropertiesLike<Pair<Long, Long>, Graph>
    {
        INSTANCE;


        @Override
        public long startId(Pair<Long, Long> startAndEndNodeId) {
            return (Long)startAndEndNodeId.getOne();
        }

        @Override
        public long endId(Pair<Long, Long> startAndEndNodeId) {
            return (Long)startAndEndNodeId.getTwo();
        }

        @Override
        public Optional<String> type(Pair<Long, Long> startAndEndNodeId) {
            return Optional.empty();
        }

        @Override
        public Iterable<String> availableKeys(Pair<Long, Long> startAndEndNodeId, Graph graph) {
            return Collections.singleton("weight");
        }

        @Override
        public Object property(String key, Pair<Long, Long> startAndEndNodeId, Graph graph) {
            return graph.relationshipProperty(((Long)startAndEndNodeId.getOne()).longValue(), ((Long)startAndEndNodeId.getTwo()).longValue(), Double.NaN);
        }
    }

    static enum GraphNode implements NodeLike<Long>,
    PropertiesLike<Long, Graph>
    {
        INSTANCE;


        @Override
        public long id(Long nodeId) {
            return nodeId;
        }

        @Override
        public Iterable<String> labels(Long aLong) {
            return Collections.emptyList();
        }

        @Override
        public Iterable<String> availableKeys(Long nodeId, Graph graph) {
            return graph.availableNodeProperties();
        }

        @Override
        public Object property(String key, Long nodeId, Graph graph) {
            return graph.nodeProperties(key).getObject(nodeId.longValue());
        }
    }

    static enum GraphData implements GraphLike<Graph, Long, Long, Pair<Long, Long>, Pair<Long, Long>>
    {
        INSTANCE;


        @Override
        public NodeLike<Long> nodeLike() {
            return GraphNode.INSTANCE;
        }

        @Override
        public RelationshipLike<Pair<Long, Long>> relLike() {
            return GraphRel.INSTANCE;
        }

        @Override
        public PropertiesLike<Long, Graph> nodePropsLike() {
            return GraphNode.INSTANCE;
        }

        @Override
        public PropertiesLike<Pair<Long, Long>, Graph> relPropsLike() {
            return GraphRel.INSTANCE;
        }

        @Override
        public void runInTx(Graph graph, Runnable action) {
            action.run();
        }

        @Override
        public void forEachNode(Graph graph, Consumer<Long> action) {
            graph.forEachNode(node -> {
                action.accept(node);
                return true;
            });
        }

        @Override
        public void forEachOutgoing(Graph graph, Long node, Consumer<Pair<Long, Long>> action) {
            graph.forEachRelationship(node.longValue(), (s, t) -> {
                action.accept(Tuples.pair((Object)s, (Object)t));
                return true;
            });
        }
    }

    static enum NeoData implements GraphLike<GraphDatabaseService, Entity, Node, Entity, Relationship>,
    NodeLike<Node>,
    RelationshipLike<Relationship>,
    PropertiesLike<Entity, GraphDatabaseService>
    {
        INSTANCE;


        @Override
        public void runInTx(GraphDatabaseService graph, Runnable action) {
            GraphDatabaseApiProxy.runInTransaction((GraphDatabaseService)graph, tx -> action.run());
        }

        @Override
        public void forEachNode(GraphDatabaseService graph, Consumer<Node> action) {
            GraphDatabaseApiProxy.runInTransaction((GraphDatabaseService)graph, tx -> tx.getAllNodes().forEach(action));
        }

        @Override
        public void forEachOutgoing(GraphDatabaseService graph, Node node, Consumer<Relationship> action) {
            node.getRelationships(Direction.OUTGOING).forEach(action);
        }

        @Override
        public long id(Node node) {
            return node.getId();
        }

        @Override
        public Iterable<String> labels(Node node) {
            return StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).collect(Collectors.toList());
        }

        @Override
        public long startId(Relationship relationship) {
            return relationship.getStartNodeId();
        }

        @Override
        public long endId(Relationship relationship) {
            return relationship.getEndNodeId();
        }

        @Override
        public Optional<String> type(Relationship relationship) {
            return Optional.of(relationship.getType().name());
        }

        @Override
        public Iterable<String> availableKeys(Entity propertyContainer, GraphDatabaseService context) {
            return propertyContainer.getPropertyKeys();
        }

        @Override
        public Object property(String key, Entity propertyContainer, GraphDatabaseService context) {
            return propertyContainer.getProperty(key);
        }

        @Override
        public NodeLike<Node> nodeLike() {
            return this;
        }

        @Override
        public RelationshipLike<Relationship> relLike() {
            return this;
        }

        @Override
        public PropertiesLike<Entity, GraphDatabaseService> nodePropsLike() {
            return this;
        }

        @Override
        public PropertiesLike<Entity, GraphDatabaseService> relPropsLike() {
            return this;
        }
    }

    static interface PropertiesLike<T, Context> {
        public Iterable<String> availableKeys(T var1, Context var2);

        public Object property(String var1, T var2, Context var3);
    }

    static interface RelationshipLike<T> {
        public long startId(T var1);

        public long endId(T var1);

        public Optional<String> type(T var1);
    }

    static interface NodeLike<T> {
        public long id(T var1);

        public Iterable<String> labels(T var1);
    }

    static interface GraphLike<G, NP, N extends NP, RP, R extends RP> {
        public NodeLike<N> nodeLike();

        public RelationshipLike<R> relLike();

        public PropertiesLike<NP, G> nodePropsLike();

        public PropertiesLike<RP, G> relPropsLike();

        public void runInTx(G var1, Runnable var2);

        public void forEachNode(G var1, Consumer<N> var2);

        public void forEachOutgoing(G var1, N var2, Consumer<R> var3);
    }
}

