/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.SplittableRandom;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.gds.BaseTest;
import org.neo4j.gds.annotation.SuppressForbidden;
import org.neo4j.gds.core.CypherExporter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

@ExtendWith(value={TestWatcherExtension.class})
public abstract class RandomGraphTestCase
extends BaseTest {
    static final int NODE_COUNT = 100;

    @BeforeEach
    protected void setupGraph() {
        this.buildGraph(100);
    }

    public final void buildGraph(int nodeCount) {
        SplittableRandom random = new SplittableRandom();
        Label label1 = Label.label((String)"Label");
        Label label2 = Label.label((String)"Label2");
        RelationshipType type = RelationshipType.withName((String)"TYPE");
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < nodeCount; ++i) {
                Node node = tx.createNode(new Label[]{label1});
                if (!random.nextBoolean()) continue;
                node.addLabel(label2);
            }
            MutableInt count = new MutableInt();
            int limit = 1000;
            double chance = 0.1;
            tx.getAllNodes().forEach(n1 -> tx.getAllNodes().forEach(n2 -> {
                if (count.getValue() < limit) {
                    if (random.nextDouble() < chance) {
                        Relationship rel = n1.createRelationshipTo(n2, type);
                        rel.setProperty("weight", (Object)(Math.ceil(10.0 * random.nextDouble()) / 10.0));
                    }
                    count.increment();
                }
            }));
            tx.commit();
        }
    }

    static class TestWatcherExtension
    implements AfterEachCallback {
        private static final ExtensionContext.Namespace DBMS_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"org", "neo4j", "dbms"});
        private static final String DBMS_KEY = "service";

        TestWatcherExtension() {
        }

        public void afterEach(ExtensionContext context) {
            Optional executionException = context.getExecutionException();
            executionException.flatMap(throwable -> this.getDbms(context)).map(dbms -> dbms.database("neo4j")).ifPresent(this::dumpGraph);
        }

        Optional<DatabaseManagementService> getDbms(ExtensionContext context) {
            return Optional.ofNullable((DatabaseManagementService)context.getStore(DBMS_NAMESPACE).get((Object)DBMS_KEY, DatabaseManagementService.class));
        }

        @SuppressForbidden(reason="this is supposed to use sys.out")
        void dumpGraph(GraphDatabaseService db) {
            try {
                PrintWriter pw = new PrintWriter(System.out, true, StandardCharsets.UTF_8);
                pw.println("Generated graph to reproduce any errors:");
                pw.println();
                CypherExporter.export(pw, db);
            }
            catch (Exception e) {
                System.err.println("Error exporting graph " + e.getMessage());
            }
        }
    }
}

