/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.stream.Stream;
import org.neo4j.gds.utils.CheckedRunnable;
import org.neo4j.gds.utils.GdsFeatureToggles;

public interface TestMethodRunner {
    public <E extends Exception> void run(CheckedRunnable<E> var1) throws E;

    public static Stream<TestMethodRunner> adjacencyCompressions() {
        return Stream.of(TestMethodRunner::runCompressedUnordered, TestMethodRunner::runCompressedOrdered, TestMethodRunner::runUncompressedUnordered, TestMethodRunner::runUncompressedOrdered);
    }

    public static <E extends Exception> void runCompressedUnordered(CheckedRunnable<E> code) throws E {
        GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.disableAndRun(() -> GdsFeatureToggles.USE_REORDERED_ADJACENCY_LIST.disableAndRun(code));
    }

    public static <E extends Exception> void runCompressedOrdered(CheckedRunnable<E> code) throws E {
        GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.disableAndRun(() -> GdsFeatureToggles.USE_REORDERED_ADJACENCY_LIST.enableAndRun(code));
    }

    public static <E extends Exception> void runUncompressedUnordered(CheckedRunnable<E> code) throws E {
        GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.enableAndRun(() -> GdsFeatureToggles.USE_REORDERED_ADJACENCY_LIST.disableAndRun(code));
    }

    public static <E extends Exception> void runUncompressedOrdered(CheckedRunnable<E> code) throws E {
        GdsFeatureToggles.USE_UNCOMPRESSED_ADJACENCY_LIST.enableAndRun(() -> GdsFeatureToggles.USE_REORDERED_ADJACENCY_LIST.enableAndRun(code));
    }
}

