/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.huge;

import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.LongPredicate;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.BatchNodeIterable;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.utils.LazyBatchCollection;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongCollections;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterator;

public class DirectIdMap
implements IdMap {
    private final long nodeCount;

    public DirectIdMap(long nodeCount) {
        this.nodeCount = nodeCount;
    }

    public long toMappedNodeId(long nodeId) {
        return nodeId;
    }

    public long toOriginalNodeId(long nodeId) {
        return nodeId;
    }

    public long toRootNodeId(long nodeId) {
        return nodeId;
    }

    public long highestNeoId() {
        throw new UnsupportedOperationException();
    }

    public boolean contains(long nodeId) {
        return nodeId < this.nodeCount;
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public OptionalLong rootNodeCount() {
        return OptionalLong.of(this.nodeCount);
    }

    public Collection<PrimitiveLongIterable> batchIterables(long batchSize) {
        return LazyBatchCollection.of((long)this.nodeCount(), (long)batchSize, BatchNodeIterable.IdIterable::new);
    }

    public List<NodeLabel> nodeLabels(long nodeId) {
        return List.of();
    }

    public void forEachNodeLabel(long nodeId, IdMap.NodeLabelConsumer consumer) {
    }

    public Set<NodeLabel> availableNodeLabels() {
        return Set.of();
    }

    public boolean hasLabel(long nodeId, NodeLabel label) {
        return false;
    }

    public IdMap rootIdMap() {
        return this;
    }

    public void forEachNode(LongPredicate consumer) {
        boolean shouldContinue;
        for (long i = 0L; i < this.nodeCount && (shouldContinue = consumer.test(i)); ++i) {
        }
    }

    public PrimitiveLongIterator nodeIterator() {
        return PrimitiveLongCollections.range((long)0L, (long)this.nodeCount);
    }
}

