/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.loading;

import java.util.HashMap;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.compress.AdjacencyCompressorFactory;
import org.neo4j.gds.core.compress.AdjacencyListBehavior;
import org.neo4j.gds.core.huge.DirectIdMap;
import org.neo4j.gds.core.loading.AdjacencyBuffer;
import org.neo4j.gds.core.loading.AdjacencyBufferBuilder;
import org.neo4j.gds.core.loading.ImmutableImportMetaData;
import org.neo4j.gds.core.loading.ImportSizing;
import org.neo4j.gds.core.loading.RelationshipsBatchBuffer;
import org.neo4j.gds.core.loading.SingleTypeRelationshipImporter;
import org.neo4j.gds.core.loading.ThreadLocalSingleTypeRelationshipImporter;

public abstract class AdjacencyListBuilderBaseTest {
    void adjacencyListTest(Optional<Long> idOffset) {
        long nodeCount = 6L;
        Long fakeNodeCount = idOffset.map(o -> nodeCount + o).orElse(nodeCount);
        Optional<AdjacencyCompressor.ValueMapper> mapper = idOffset.map(offset -> value -> value + offset);
        AdjacencyCompressor.ValueMapper toMapped = mapper.orElseGet(() -> id -> id);
        SingleTypeRelationshipImporter.ImportMetaData importMetaData = ImmutableImportMetaData.builder().projection(RelationshipProjection.of((String)"", (Orientation)Orientation.NATURAL, (Aggregation)Aggregation.NONE)).aggregations(new Aggregation[]{Aggregation.NONE}).propertyKeyIds(new int[0]).defaultValues(new double[0]).typeTokenId(-1).build();
        AdjacencyCompressorFactory adjacencyCompressorFactory = AdjacencyListBehavior.asConfigured(() -> fakeNodeCount, (PropertyMappings)PropertyMappings.of(), (Aggregation[])importMetaData.aggregations());
        AdjacencyBuffer adjacencyBuffer = new AdjacencyBufferBuilder().adjacencyCompressorFactory(adjacencyCompressorFactory).importMetaData(importMetaData).importSizing(ImportSizing.of((int)1, (long)nodeCount)).build();
        DirectIdMap idMap = new DirectIdMap(nodeCount);
        RelationshipsBatchBuffer relationshipsBatchBuffer = new RelationshipsBatchBuffer((PartialIdMap)idMap, -1, 10);
        HashMap<Long, Long> relationships = new HashMap<Long, Long>();
        for (long i = 0L; i < nodeCount; ++i) {
            relationships.put(i, nodeCount - i);
            relationshipsBatchBuffer.add(i, nodeCount - i);
        }
        ThreadLocalSingleTypeRelationshipImporter importer = ThreadLocalSingleTypeRelationshipImporter.of((AdjacencyBuffer)adjacencyBuffer, (RelationshipsBatchBuffer)relationshipsBatchBuffer, (SingleTypeRelationshipImporter.ImportMetaData)importMetaData, null);
        importer.importRelationships();
        adjacencyBuffer.adjacencyListBuilderTasks(mapper).forEach(Runnable::run);
        try (AdjacencyList adjacencyList = adjacencyCompressorFactory.build().adjacency();){
            for (long nodeId = 0L; nodeId < nodeCount; ++nodeId) {
                try (AdjacencyCursor cursor = adjacencyList.adjacencyCursor(toMapped.map(nodeId));){
                    while (cursor.hasNextVLong()) {
                        long target = cursor.nextVLong();
                        long expected = toMapped.map(((Long)relationships.remove(nodeId)).longValue());
                        org.junit.jupiter.api.Assertions.assertEquals((long)expected, (long)target);
                    }
                    continue;
                }
            }
            Assertions.assertThat(relationships).isEmpty();
        }
    }

    void testAdjacencyList() {
        this.adjacencyListTest(Optional.empty());
    }

    void testValueMapper() {
        this.adjacencyListTest(Optional.of(10000L));
    }
}

