/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.model;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.neo4j.gds.core.model.InjectModelCatalog;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.model.OpenModelCatalog;
import org.neo4j.gds.utils.StringFormatting;

public class TestOpenModelCatalogResolver
implements ParameterResolver,
TestInstancePostProcessor,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"gds"});
    private static final Class<InjectModelCatalog> INJECT_CLASS = InjectModelCatalog.class;
    private static final Class<ModelCatalog> INJECT_TARGET_CLASS = ModelCatalog.class;

    public void afterEach(ExtensionContext context) throws Exception {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        ModelCatalog modelCatalog = (ModelCatalog)store.get(INJECT_CLASS, INJECT_TARGET_CLASS);
        if (modelCatalog == null) {
            throw new IllegalStateException("No ModelCatalog injected, but used @ModelCatalogExtension");
        }
        modelCatalog.removeAllLoadedModels();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.isAnnotated(INJECT_CLASS)) {
            return parameterContext.getParameter().getType().isAssignableFrom(INJECT_TARGET_CLASS);
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.modelCatalogFromExtensionStore(extensionContext, (InjectModelCatalog)parameterContext.findAnnotation(INJECT_CLASS).orElseThrow());
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        Stream.iterate(testInstance.getClass(), Objects::nonNull, Class::getSuperclass).flatMap(c -> Arrays.stream(c.getDeclaredFields())).filter(c -> c.isAnnotationPresent(INJECT_CLASS)).filter(c -> c.getType().isAssignableFrom(INJECT_TARGET_CLASS)).forEach(field -> this.setValueToField(testInstance, context, (Field)field));
    }

    private void setValueToField(Object testInstance, ExtensionContext context, Field field) {
        try {
            this.trySetValueToField(testInstance, context, field);
        }
        catch (IllegalAccessException e) {
            try {
                field.setAccessible(true);
                this.trySetValueToField(testInstance, context, field);
            }
            catch (IllegalAccessException | SecurityException | InaccessibleObjectException illegalAccessException) {
                throw new ExtensionConfigurationException(StringFormatting.formatWithLocale((String)"Field %s cannot be set, please make it either public or accessible to reflection.", (Object[])new Object[]{field.getName()}));
            }
        }
    }

    private void trySetValueToField(Object testInstance, ExtensionContext extensionContext, Field field) throws IllegalAccessException {
        Object testObject = Modifier.isStatic(field.getModifiers()) ? null : testInstance;
        Object existingValue = field.get(testObject);
        if (existingValue != null) {
            throw new ExtensionConfigurationException(StringFormatting.formatWithLocale((String)"Field %s should not have any manually assigned value.", (Object[])new Object[]{field.getName()}));
        }
        InjectModelCatalog annotation = field.getAnnotation(INJECT_CLASS);
        ModelCatalog value = this.modelCatalogFromExtensionStore(extensionContext, annotation);
        field.set(testObject, value);
    }

    private ModelCatalog modelCatalogFromExtensionStore(ExtensionContext extensionContext, InjectModelCatalog annotation) {
        ExtensionContext.Store store = extensionContext.getStore(NAMESPACE);
        return (ModelCatalog)store.getOrComputeIfAbsent(INJECT_CLASS, annotationClass -> new OpenModelCatalog(), INJECT_TARGET_CLASS);
    }
}

