/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.extension;

import java.time.Clock;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.gds.core.utils.ClockService;
import org.neo4j.gds.extension.ExtensionUtil;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class FakeClockSupportExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final FakeClock FAKE_CLOCK = Clocks.fakeClock();
    private Clock clockBefore;

    public void beforeEach(ExtensionContext context) throws Exception {
        this.clockBefore = ClockService.clock();
        ClockService.setClock((Clock)FAKE_CLOCK);
        context.getRequiredTestInstances().getAllInstances().forEach(testInstance -> ExtensionUtil.injectInstance((Object)testInstance, (Object)FAKE_CLOCK, FakeClock.class));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ClockService.setClock((Clock)this.clockBefore);
        this.clockBefore = null;
    }
}

