/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.CSRGraph;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.extension.ExtensionUtil;
import org.neo4j.gds.extension.GdlGraph;
import org.neo4j.gds.extension.GdlGraphs;
import org.neo4j.gds.extension.IdFunction;
import org.neo4j.gds.extension.ImmutableGdlGraphSetup;
import org.neo4j.gds.extension.Inject;
import org.neo4j.gds.extension.TestGraph;
import org.neo4j.gds.gdl.GdlFactory;
import org.neo4j.gds.gdl.GraphProjectFromGdlConfig;
import org.neo4j.gds.gdl.ImmutableGraphProjectFromGdlConfig;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;

public class GdlSupportExtension
implements BeforeEachCallback,
AfterEachCallback {
    public static final NamedDatabaseId DATABASE_ID = DatabaseIdFactory.from((String)"GDL", (UUID)UUID.fromString("42-42-42-42-42"));

    public void beforeEach(ExtensionContext context) {
        Class requiredTestClass = context.getRequiredTestClass();
        GdlSupportExtension.gdlGraphs(requiredTestClass).forEach(setup -> GdlSupportExtension.injectGraphStore(setup, context));
    }

    public void afterEach(ExtensionContext context) {
        GraphStoreCatalog.removeAllLoadedGraphs();
    }

    private static Collection<GdlGraphSetup> gdlGraphs(Class<?> testClass) {
        HashSet<GdlGraphSetup> setups = new HashSet<GdlGraphSetup>();
        do {
            Arrays.stream(testClass.getDeclaredFields()).filter(f -> f.isAnnotationPresent(GdlGraph.class) || f.isAnnotationPresent(GdlGraphs.class)).flatMap(GdlSupportExtension::gdlGraphsForField).peek(setup -> {
                if (setups.contains(setup)) {
                    throw new ExtensionConfigurationException(String.format(Locale.ENGLISH, "Graph names prefixes must be unique. Found duplicate graph name prefixes '%s'.", setup.graphNamePrefix()));
                }
            }).forEach(setups::add);
        } while ((testClass = testClass.getSuperclass()) != null);
        if (setups.isEmpty()) {
            throw new ExtensionConfigurationException(String.format(Locale.ENGLISH, "At least one field must be annotated with %s.", GdlGraph.class.getTypeName()));
        }
        return setups;
    }

    private static Stream<GdlGraphSetup> gdlGraphsForField(Field field) {
        String gdl = ExtensionUtil.getStringValueOfField((Field)field);
        Stream<GdlGraph> annotations = field.isAnnotationPresent(GdlGraph.class) ? Stream.of(field.getAnnotation(GdlGraph.class)) : Arrays.stream(field.getAnnotation(GdlGraphs.class).value());
        return annotations.map(annotation -> ImmutableGdlGraphSetup.of(annotation.graphNamePrefix(), gdl, annotation.username(), annotation.orientation(), annotation.aggregation(), annotation.addToCatalog()));
    }

    private static void injectGraphStore(GdlGraphSetup gdlGraphSetup, ExtensionContext context) {
        String graphNamePrefix = gdlGraphSetup.graphNamePrefix();
        Object graphName = graphNamePrefix.isBlank() ? "graph" : graphNamePrefix + "Graph";
        GraphProjectFromGdlConfig graphProjectConfig = ImmutableGraphProjectFromGdlConfig.builder().username(gdlGraphSetup.username()).graphName((String)graphName).gdlGraph(gdlGraphSetup.gdlGraph()).orientation(gdlGraphSetup.orientation()).aggregation(gdlGraphSetup.aggregation()).build();
        GdlFactory gdlFactory = GdlFactory.builder().graphProjectConfig(graphProjectConfig).namedDatabaseId(DATABASE_ID).build();
        CSRGraphStore graphStore = gdlFactory.build();
        CSRGraph graph = graphStore.getUnion();
        IdFunction idFunction = gdlFactory::nodeId;
        TestGraph testGraph = new TestGraph(graph, idFunction, (String)graphName);
        if (gdlGraphSetup.addToCatalog()) {
            GraphStoreCatalog.set((GraphProjectConfig)graphProjectConfig, (GraphStore)graphStore);
        }
        context.getRequiredTestInstances().getAllInstances().forEach(testInstance -> {
            GdlSupportExtension.injectInstance(testInstance, graphNamePrefix, graph, Graph.class, "Graph");
            GdlSupportExtension.injectInstance(testInstance, graphNamePrefix, graph, CSRGraph.class, "Graph");
            GdlSupportExtension.injectInstance(testInstance, graphNamePrefix, testGraph, TestGraph.class, "Graph");
            GdlSupportExtension.injectInstance(testInstance, graphNamePrefix, graphStore, GraphStore.class, "GraphStore");
            GdlSupportExtension.injectInstance(testInstance, graphNamePrefix, idFunction, IdFunction.class, "IdFunction");
        });
    }

    private static <T> void injectInstance(Object testInstance, String graphNamePrefix, T instance, Class<T> clazz, String suffix) {
        Stream.iterate(testInstance.getClass(), Objects::nonNull, Class::getSuperclass).flatMap(c -> Arrays.stream(c.getDeclaredFields())).filter(field -> field.getType() == clazz).filter(field -> AnnotationSupport.isAnnotated((AnnotatedElement)field, Inject.class)).filter(field -> field.getName().equalsIgnoreCase(graphNamePrefix + suffix)).forEach(field -> ExtensionUtil.setField((Object)testInstance, (Field)field, (Object)instance));
    }

    @ValueClass
    static interface GdlGraphSetup {
        public String graphNamePrefix();

        @Value.Auxiliary
        public String gdlGraph();

        @Value.Auxiliary
        public String username();

        @Value.Auxiliary
        public Orientation orientation();

        @Value.Auxiliary
        public Aggregation aggregation();

        @Value.Auxiliary
        @Value.Default
        default public boolean addToCatalog() {
            return false;
        }
    }
}

