/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.extension;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.extension.GdlSupportExtension;

@Generated(from="GdlSupportExtension.GdlGraphSetup", generator="Immutables")
public final class ImmutableGdlGraphSetup
implements GdlSupportExtension.GdlGraphSetup {
    private final String graphNamePrefix;
    private final String gdlGraph;
    private final String username;
    private final Orientation orientation;
    private final Aggregation aggregation;
    private final boolean addToCatalog;

    private ImmutableGdlGraphSetup(String graphNamePrefix, String gdlGraph, String username, Orientation orientation, Aggregation aggregation, boolean addToCatalog) {
        this.graphNamePrefix = Objects.requireNonNull(graphNamePrefix, "graphNamePrefix");
        this.gdlGraph = Objects.requireNonNull(gdlGraph, "gdlGraph");
        this.username = Objects.requireNonNull(username, "username");
        this.orientation = Objects.requireNonNull(orientation, "orientation");
        this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
        this.addToCatalog = addToCatalog;
    }

    private ImmutableGdlGraphSetup(Builder builder) {
        this.graphNamePrefix = builder.graphNamePrefix;
        this.gdlGraph = builder.gdlGraph;
        this.username = builder.username;
        this.orientation = builder.orientation;
        this.aggregation = builder.aggregation;
        this.addToCatalog = builder.addToCatalogIsSet() ? builder.addToCatalog : GdlSupportExtension.GdlGraphSetup.super.addToCatalog();
    }

    private ImmutableGdlGraphSetup(ImmutableGdlGraphSetup original, String graphNamePrefix, String gdlGraph, String username, Orientation orientation, Aggregation aggregation, boolean addToCatalog) {
        this.graphNamePrefix = graphNamePrefix;
        this.gdlGraph = gdlGraph;
        this.username = username;
        this.orientation = orientation;
        this.aggregation = aggregation;
        this.addToCatalog = addToCatalog;
    }

    @Override
    public String graphNamePrefix() {
        return this.graphNamePrefix;
    }

    @Override
    public String gdlGraph() {
        return this.gdlGraph;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public Orientation orientation() {
        return this.orientation;
    }

    @Override
    public Aggregation aggregation() {
        return this.aggregation;
    }

    @Override
    public boolean addToCatalog() {
        return this.addToCatalog;
    }

    public final ImmutableGdlGraphSetup withGraphNamePrefix(String value) {
        String newValue = Objects.requireNonNull(value, "graphNamePrefix");
        if (this.graphNamePrefix.equals(newValue)) {
            return this;
        }
        return new ImmutableGdlGraphSetup(this, newValue, this.gdlGraph, this.username, this.orientation, this.aggregation, this.addToCatalog);
    }

    public final ImmutableGdlGraphSetup withGdlGraph(String value) {
        String newValue = Objects.requireNonNull(value, "gdlGraph");
        if (this.gdlGraph.equals(newValue)) {
            return this;
        }
        return new ImmutableGdlGraphSetup(this, this.graphNamePrefix, newValue, this.username, this.orientation, this.aggregation, this.addToCatalog);
    }

    public final ImmutableGdlGraphSetup withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableGdlGraphSetup(this, this.graphNamePrefix, this.gdlGraph, newValue, this.orientation, this.aggregation, this.addToCatalog);
    }

    public final ImmutableGdlGraphSetup withOrientation(Orientation value) {
        if (this.orientation == value) {
            return this;
        }
        Orientation newValue = Objects.requireNonNull(value, "orientation");
        if (this.orientation.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableGdlGraphSetup(this, this.graphNamePrefix, this.gdlGraph, this.username, newValue, this.aggregation, this.addToCatalog);
    }

    public final ImmutableGdlGraphSetup withAggregation(Aggregation value) {
        if (this.aggregation == value) {
            return this;
        }
        Aggregation newValue = Objects.requireNonNull(value, "aggregation");
        if (this.aggregation.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableGdlGraphSetup(this, this.graphNamePrefix, this.gdlGraph, this.username, this.orientation, newValue, this.addToCatalog);
    }

    public final ImmutableGdlGraphSetup withAddToCatalog(boolean value) {
        if (this.addToCatalog == value) {
            return this;
        }
        return new ImmutableGdlGraphSetup(this, this.graphNamePrefix, this.gdlGraph, this.username, this.orientation, this.aggregation, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGdlGraphSetup && this.equalTo((ImmutableGdlGraphSetup)another);
    }

    private boolean equalTo(ImmutableGdlGraphSetup another) {
        return this.graphNamePrefix.equals(another.graphNamePrefix);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.graphNamePrefix.hashCode();
        return h;
    }

    public String toString() {
        return "GdlGraphSetup{graphNamePrefix=" + this.graphNamePrefix + "}";
    }

    public static GdlSupportExtension.GdlGraphSetup of(String graphNamePrefix, String gdlGraph, String username, Orientation orientation, Aggregation aggregation, boolean addToCatalog) {
        return new ImmutableGdlGraphSetup(graphNamePrefix, gdlGraph, username, orientation, aggregation, addToCatalog);
    }

    static GdlSupportExtension.GdlGraphSetup copyOf(GdlSupportExtension.GdlGraphSetup instance) {
        if (instance instanceof ImmutableGdlGraphSetup) {
            return (ImmutableGdlGraphSetup)instance;
        }
        return ImmutableGdlGraphSetup.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GdlSupportExtension.GdlGraphSetup", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_GRAPH_NAME_PREFIX = 1L;
        private static final long INIT_BIT_GDL_GRAPH = 2L;
        private static final long INIT_BIT_USERNAME = 4L;
        private static final long INIT_BIT_ORIENTATION = 8L;
        private static final long INIT_BIT_AGGREGATION = 16L;
        private static final long OPT_BIT_ADD_TO_CATALOG = 1L;
        private long initBits = 31L;
        private long optBits;
        private String graphNamePrefix;
        private String gdlGraph;
        private String username;
        private Orientation orientation;
        private Aggregation aggregation;
        private boolean addToCatalog;

        private Builder() {
        }

        public final Builder from(ImmutableGdlGraphSetup instance) {
            return this.from((GdlSupportExtension.GdlGraphSetup)instance);
        }

        final Builder from(GdlSupportExtension.GdlGraphSetup instance) {
            Objects.requireNonNull(instance, "instance");
            this.graphNamePrefix(instance.graphNamePrefix());
            this.gdlGraph(instance.gdlGraph());
            this.username(instance.username());
            this.orientation(instance.orientation());
            this.aggregation(instance.aggregation());
            this.addToCatalog(instance.addToCatalog());
            return this;
        }

        public final Builder graphNamePrefix(String graphNamePrefix) {
            this.graphNamePrefix = Objects.requireNonNull(graphNamePrefix, "graphNamePrefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder gdlGraph(String gdlGraph) {
            this.gdlGraph = Objects.requireNonNull(gdlGraph, "gdlGraph");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder orientation(Orientation orientation) {
            this.orientation = Objects.requireNonNull(orientation, "orientation");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder aggregation(Aggregation aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addToCatalog(boolean addToCatalog) {
            this.addToCatalog = addToCatalog;
            this.optBits |= 1L;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.optBits = 0L;
            this.graphNamePrefix = null;
            this.gdlGraph = null;
            this.username = null;
            this.orientation = null;
            this.aggregation = null;
            this.addToCatalog = false;
            return this;
        }

        public GdlSupportExtension.GdlGraphSetup build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGdlGraphSetup(this);
        }

        private boolean addToCatalogIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("graphNamePrefix");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("gdlGraph");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("orientation");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("aggregation");
            }
            return "Cannot build GdlGraphSetup, some of required attributes are not set " + attributes;
        }
    }
}

