/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.extension;

import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.extension.ExtensionUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class Neo4jModelCatalogResolver
implements BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace DBMS_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"org", "neo4j", "dbms"});
    private static final String DBMS_KEY = "service";

    public void beforeEach(ExtensionContext context) throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.getDbms(context).map(dbms -> dbms.database("neo4j")).orElseThrow(() -> new IllegalStateException("No database was found."));
        this.injectFields(context, this.getModelCatalog(db));
    }

    private ModelCatalog getModelCatalog(GraphDatabaseAPI db) {
        return (ModelCatalog)db.getDependencyResolver().resolveDependency(ModelCatalog.class);
    }

    private Optional<DatabaseManagementService> getDbms(ExtensionContext context) {
        return Optional.ofNullable((DatabaseManagementService)context.getStore(DBMS_NAMESPACE).get((Object)DBMS_KEY, DatabaseManagementService.class));
    }

    private void injectFields(ExtensionContext context, ModelCatalog modelCatalog) {
        context.getRequiredTestInstances().getAllInstances().forEach(testInstance -> ExtensionUtil.injectInstance((Object)testInstance, (Object)modelCatalog, ModelCatalog.class));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.getDbms(context).map(dbms -> dbms.database("neo4j")).orElseThrow(() -> new IllegalStateException("No database was found."));
        this.getModelCatalog(db).removeAllLoadedModels();
    }
}

