/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.extension;

import com.carrotsearch.hppc.BitSet;
import org.neo4j.gds.api.CSRGraph;
import org.neo4j.gds.api.CSRGraphAdapter;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.extension.IdFunction;

public class TestGraph
extends CSRGraphAdapter {
    private final IdFunction idFunction;
    private final String name;

    public TestGraph(CSRGraph graph, IdFunction idFunction, String name) {
        super(graph);
        this.name = name;
        this.idFunction = idFunction;
    }

    public Graph innerGraph() {
        return this.csrGraph;
    }

    public long toOriginalNodeId(String variable) {
        return this.idFunction.of(variable);
    }

    public long toMappedNodeId(String variable) {
        return this.csrGraph.toMappedNodeId(this.idFunction.of(variable));
    }

    public int degreeWithoutParallelRelationships(long nodeId) {
        BitSet bitset = BitSet.newInstance();
        this.forEachRelationship(nodeId, (source, target) -> {
            bitset.set(target);
            return true;
        });
        return Math.toIntExact(bitset.cardinality());
    }

    public CSRGraph concurrentCopy() {
        return new TestGraph(this.csrGraph.concurrentCopy(), this.idFunction, this.name);
    }

    public String toString() {
        return this.name;
    }
}

