/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.gdl;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.immutables.builder.Builder;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.CSRGraphStoreFactory;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.PropertyState;
import org.neo4j.gds.api.RelationshipProperty;
import org.neo4j.gds.api.RelationshipPropertyStore;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.RelationshipSchema;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.ImmutableGraphDimensions;
import org.neo4j.gds.core.Username;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.IdMapAndProperties;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodeLabelTokens;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.loading.nodeproperties.NodePropertiesFromStoreBuilder;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.extension.GdlSupportExtension;
import org.neo4j.gds.gdl.GdlFactoryBuilder;
import org.neo4j.gds.gdl.GraphProjectFromGdlConfig;
import org.neo4j.gds.gdl.ImmutableGraphProjectFromGdlConfig;
import org.neo4j.gds.gdl.ImmutableRelationshipsLoadResult;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.values.storable.NumberType;
import org.neo4j.values.storable.Values;
import org.s1ck.gdl.GDLHandler;
import org.s1ck.gdl.model.Element;
import org.s1ck.gdl.model.Vertex;
import org.s1ck.gdl.utils.ContinuousId;

public final class GdlFactory
extends CSRGraphStoreFactory<GraphProjectFromGdlConfig> {
    private final GDLHandler gdlHandler;
    private final NamedDatabaseId databaseId;

    public static GdlFactory of(String gdlGraph) {
        return GdlFactory.builder().gdlGraph(gdlGraph).build();
    }

    public static GdlFactoryBuilder builder() {
        return new GdlFactoryBuilder();
    }

    @Builder.Factory
    static GdlFactory gdlFactory(Optional<String> gdlGraph, Optional<NamedDatabaseId> namedDatabaseId, Optional<String> userName, Optional<String> graphName, Optional<GraphProjectFromGdlConfig> graphProjectConfig, Optional<LongSupplier> nodeIdFunction) {
        GraphProjectFromGdlConfig config = graphProjectConfig.isEmpty() ? ImmutableGraphProjectFromGdlConfig.builder().username(userName.orElse(Username.EMPTY_USERNAME.username())).graphName(graphName.orElse("graph")).gdlGraph(gdlGraph.orElse("")).build() : graphProjectConfig.get();
        NamedDatabaseId databaseId = namedDatabaseId.orElse(GdlSupportExtension.DATABASE_ID);
        Function nextVertexId = nodeIdFunction.map(supplier -> ignored -> supplier.getAsLong()).orElseGet(ContinuousId::new);
        GDLHandler gdlHandler = new GDLHandler.Builder().setNextVertexId(nextVertexId).setDefaultVertexLabel(NodeLabel.ALL_NODES.name).setDefaultEdgeLabel(RelationshipType.ALL_RELATIONSHIPS.name).buildFromString(config.gdlGraph());
        GraphDimensions graphDimensions = GraphDimensionsGdlReader.of(gdlHandler);
        return new GdlFactory(gdlHandler, config, graphDimensions, databaseId);
    }

    private GdlFactory(GDLHandler gdlHandler, GraphProjectFromGdlConfig graphProjectConfig, GraphDimensions graphDimensions, NamedDatabaseId databaseId) {
        super((GraphProjectConfig)graphProjectConfig, GraphLoaderContext.NULL_CONTEXT, graphDimensions);
        this.gdlHandler = gdlHandler;
        this.databaseId = databaseId;
    }

    public long nodeId(String variable) {
        return ((Vertex)this.gdlHandler.getVertexCache().get(variable)).getId();
    }

    public MemoryEstimation estimateMemoryUsageDuringLoading() {
        return MemoryEstimations.empty();
    }

    public MemoryEstimation estimateMemoryUsageAfterLoading() {
        return MemoryEstimations.empty();
    }

    protected ProgressTracker initProgressTracker() {
        return ProgressTracker.NULL_TRACKER;
    }

    public CSRGraphStore build() {
        IdMapAndProperties nodes = this.loadNodes();
        List<RelationshipsLoadResult> relationships = this.loadRelationships(nodes.idMap());
        HashMap topologies = new HashMap();
        HashMap properties = new HashMap();
        relationships.forEach(loadResult -> {
            RelationshipPropertyStore.Builder builder = RelationshipPropertyStore.builder();
            loadResult.properties().forEach((propertyKey, propertyValues) -> builder.putIfAbsent(propertyKey, RelationshipProperty.of((String)propertyKey, (NumberType)NumberType.FLOATING_POINT, (PropertyState)PropertyState.PERSISTENT, (Relationships.Properties)propertyValues, (DefaultValue)DefaultValue.forDouble(), (Aggregation)((GraphProjectFromGdlConfig)this.graphProjectConfig).aggregation())));
            topologies.put(loadResult.relationshipType(), loadResult.topology());
            properties.put(loadResult.relationshipType(), builder.build());
        });
        return CSRGraphStore.of((NamedDatabaseId)this.databaseId, (IdMap)nodes.idMap(), (Map)nodes.properties(), topologies, properties, (int)1);
    }

    private IdMapAndProperties loadNodes() {
        NodesBuilder nodesBuilder = GraphFactory.initNodesBuilder().maxOriginalId(this.dimensions.highestPossibleNodeCount() - 1L).hasLabelInformation(true).concurrency(1).build();
        this.gdlHandler.getVertices().forEach(vertex -> {
            List labels = vertex.getLabels();
            if (labels.contains(NodeLabel.ALL_NODES.name())) {
                labels = labels.stream().filter(label -> !NodeLabel.ALL_NODES.name().equals(label)).collect(Collectors.toList());
            }
            nodesBuilder.addNode(vertex.getId(), NodeLabelTokens.of((Object)labels));
        });
        IdMap idMap = nodesBuilder.build().idMap();
        return IdMapAndProperties.of((IdMap)idMap, this.loadNodeProperties(idMap));
    }

    private Map<NodeLabel, Map<PropertyMapping, NodeProperties>> loadNodeProperties(IdMap idMap) {
        HashMap propertyKeysByLabel = new HashMap();
        HashMap propertyBuilders = new HashMap();
        this.gdlHandler.getVertices().forEach(vertex -> vertex.getProperties().forEach((propertyKey, propertyValue) -> {
            vertex.getLabels().stream().map(NodeLabel::of).forEach(nodeLabel -> propertyKeysByLabel.computeIfAbsent(nodeLabel, ignore -> new HashSet()).add(PropertyMapping.of((String)propertyKey)));
            if (propertyValue instanceof List) {
                propertyValue = this.convertListProperty((List)propertyValue);
            }
            propertyBuilders.computeIfAbsent(PropertyMapping.of((String)propertyKey), key -> NodePropertiesFromStoreBuilder.of((DefaultValue)DefaultValue.DEFAULT, (int)1)).set(vertex.getId(), Values.of((Object)propertyValue));
        }));
        Map<PropertyMapping, NodeProperties> nodeProperties = propertyBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((NodePropertiesFromStoreBuilder)entry.getValue()).build(idMap)));
        return propertyKeysByLabel.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().collect(Collectors.toMap(propertyKey -> propertyKey, nodeProperties::get))));
    }

    @NotNull
    private Object convertListProperty(List<?> list) {
        Class<?> firstType = list.get(0).getClass();
        boolean isLong = firstType.equals(Long.class);
        boolean isDouble = firstType.equals(Double.class);
        boolean isFloat = firstType.equals(Float.class);
        if (!(isLong || isDouble || isFloat)) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"List property contains in-compatible type: %s.", (Object[])new Object[]{firstType.getSimpleName()}));
        }
        boolean sameType = list.stream().allMatch(firstType::isInstance);
        if (!sameType) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"List property contains mixed types: %s", (Object[])new Object[]{list.stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ", "[", "]"))}));
        }
        Object array = Array.newInstance(firstType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, firstType.cast(list.get(i)));
        }
        return array;
    }

    private List<RelationshipsLoadResult> loadRelationships(IdMap idMap) {
        HashMap<RelationshipType, List<String>> propertyKeysByRelType = this.propertyKeysByRelType();
        Map<RelationshipType, RelationshipsBuilder> relationshipBuilders = this.createRelationshipBuilders(idMap, propertyKeysByRelType);
        this.importRelationships(propertyKeysByRelType, relationshipBuilders);
        return relationshipBuilders.entrySet().stream().map(entry -> {
            List relationships = ((RelationshipsBuilder)entry.getValue()).buildAll();
            Relationships.Topology topology = ((Relationships)relationships.get(0)).topology();
            List propertyKeys = (List)propertyKeysByRelType.get(entry.getKey());
            Map<String, Relationships.Properties> properties = IntStream.range(0, propertyKeys.size()).boxed().collect(Collectors.toMap(propertyKeys::get, idx -> (Relationships.Properties)((Relationships)relationships.get((int)idx)).properties().get()));
            return ImmutableRelationshipsLoadResult.builder().relationshipType((RelationshipType)entry.getKey()).topology(topology).properties(properties).build();
        }).collect(Collectors.toList());
    }

    @NotNull
    private HashMap<RelationshipType, List<String>> propertyKeysByRelType() {
        HashMap<RelationshipType, List<String>> propertyKeysByRelType = new HashMap<RelationshipType, List<String>>();
        RelationshipSchema.Builder schemaBuilder = RelationshipSchema.builder();
        this.gdlHandler.getEdges().forEach(edge -> {
            RelationshipType relType = RelationshipType.of((String)edge.getLabel());
            schemaBuilder.addRelationshipType(relType);
            edge.getProperties().keySet().forEach(propertyKey -> schemaBuilder.addProperty(relType, propertyKey, ValueType.DOUBLE));
        });
        RelationshipSchema schema = schemaBuilder.build();
        schema.properties().forEach((relType, properties) -> propertyKeysByRelType.put((RelationshipType)relType, properties.keySet().stream().sorted().collect(Collectors.toList())));
        return propertyKeysByRelType;
    }

    private void importRelationships(Map<RelationshipType, List<String>> propertyKeysByRelType, Map<RelationshipType, RelationshipsBuilder> relationshipBuilders) {
        this.gdlHandler.getEdges().forEach(edge -> {
            RelationshipType relType = RelationshipType.of((String)edge.getLabel());
            RelationshipsBuilder relationshipsBuilder = (RelationshipsBuilder)relationshipBuilders.get(relType);
            List propertyKeys = (List)propertyKeysByRelType.get(relType);
            if (propertyKeys.isEmpty()) {
                relationshipsBuilder.add(edge.getSourceVertexId().longValue(), edge.getTargetVertexId().longValue());
            } else if (propertyKeys.size() == 1) {
                relationshipsBuilder.add(edge.getSourceVertexId().longValue(), edge.getTargetVertexId().longValue(), this.gdsValue((Element)edge, (String)propertyKeys.get(0), edge.getProperties().get(propertyKeys.get(0))));
            } else {
                double[] values = propertyKeys.stream().map(key -> this.gdsValue((Element)edge, (String)key, edge.getProperties().get(key))).mapToDouble(d -> d).toArray();
                relationshipsBuilder.add(edge.getSourceVertexId().longValue(), edge.getTargetVertexId().longValue(), values);
            }
        });
    }

    @NotNull
    private Map<RelationshipType, RelationshipsBuilder> createRelationshipBuilders(IdMap idMap, Map<RelationshipType, List<String>> propertyKeysByRelType) {
        return propertyKeysByRelType.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, relTypeAndProperty -> {
            List propertyKeys = (List)relTypeAndProperty.getValue();
            List propertyConfigs = propertyKeys.stream().map(key -> GraphFactory.PropertyConfig.of((Aggregation)((GraphProjectFromGdlConfig)this.graphProjectConfig).aggregation(), (DefaultValue)DefaultValue.forDouble())).collect(Collectors.toList());
            return GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)idMap).orientation(((GraphProjectFromGdlConfig)this.graphProjectConfig).orientation()).aggregation(((GraphProjectFromGdlConfig)this.graphProjectConfig).aggregation()).addAllPropertyConfigs(propertyConfigs).executorService(this.loadingContext.executor()).build();
        }));
    }

    private double gdsValue(Element element, String propertyKey, Object gdlValue) {
        if (gdlValue == null) {
            return DefaultValue.forDouble().doubleValue();
        }
        if (gdlValue instanceof Number) {
            return ((Number)gdlValue).doubleValue();
        }
        if (gdlValue instanceof String && gdlValue.equals("NaN")) {
            return Double.NaN;
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s property '%s' must be of type Number, but was %s for %s.", element.getClass().getTypeName(), propertyKey, gdlValue.getClass(), element));
    }

    private static final class GraphDimensionsGdlReader {
        private GraphDimensionsGdlReader() {
        }

        static GraphDimensions of(GDLHandler gdlHandler) {
            int nodeCount = gdlHandler.getVertices().size();
            Long highestId = gdlHandler.getVertices().stream().map(Element::getId).max(Long::compareTo).orElse(Long.valueOf(nodeCount));
            int relCount = gdlHandler.getEdges().size();
            return ImmutableGraphDimensions.builder().nodeCount((long)nodeCount).highestPossibleNodeCount(highestId + 1L).relCountUpperBound((long)relCount).build();
        }
    }

    @ValueClass
    static interface RelationshipsLoadResult {
        public RelationshipType relationshipType();

        public Relationships.Topology topology();

        public Map<String, Relationships.Properties> properties();
    }
}

