/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.gdl;

import org.immutables.value.Value;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.gdl.GdlFactory;

@ValueClass
public interface GraphProjectFromGdlConfig
extends GraphProjectConfig {
    public String gdlGraph();

    @Value.Default
    default public Orientation orientation() {
        return Orientation.NATURAL;
    }

    @Value.Default
    default public Aggregation aggregation() {
        return Aggregation.NONE;
    }

    default public GraphStoreFactory.Supplier graphStoreFactory() {
        return loaderContext -> GdlFactory.builder().graphProjectConfig(this).namedDatabaseId(loaderContext.api().databaseId()).build();
    }

    @Configuration.Ignore
    default public <R> R accept(GraphProjectConfig.Cases<R> cases) {
        if (cases instanceof Cases) {
            return ((Cases)cases).gdl(this);
        }
        throw new IllegalArgumentException("Expected Visitor of type " + Cases.class.getName());
    }

    public static interface Cases<R>
    extends GraphProjectConfig.Cases<R> {
        public R gdl(GraphProjectFromGdlConfig var1);
    }
}

