/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.gdl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.gdl.GdlFactory;

@Generated(from="GdlFactory.RelationshipsLoadResult", generator="Immutables")
public final class ImmutableRelationshipsLoadResult
implements GdlFactory.RelationshipsLoadResult {
    private final RelationshipType relationshipType;
    private final Relationships.Topology topology;
    private final Map<String, Relationships.Properties> properties;

    private ImmutableRelationshipsLoadResult(RelationshipType relationshipType, Relationships.Topology topology, Map<String, ? extends Relationships.Properties> properties) {
        this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
        this.topology = Objects.requireNonNull(topology, "topology");
        this.properties = ImmutableRelationshipsLoadResult.createUnmodifiableMap(true, false, properties);
    }

    private ImmutableRelationshipsLoadResult(ImmutableRelationshipsLoadResult original, RelationshipType relationshipType, Relationships.Topology topology, Map<String, Relationships.Properties> properties) {
        this.relationshipType = relationshipType;
        this.topology = topology;
        this.properties = properties;
    }

    @Override
    public RelationshipType relationshipType() {
        return this.relationshipType;
    }

    @Override
    public Relationships.Topology topology() {
        return this.topology;
    }

    @Override
    public Map<String, Relationships.Properties> properties() {
        return this.properties;
    }

    public final ImmutableRelationshipsLoadResult withRelationshipType(RelationshipType value) {
        if (this.relationshipType == value) {
            return this;
        }
        RelationshipType newValue = Objects.requireNonNull(value, "relationshipType");
        return new ImmutableRelationshipsLoadResult(this, newValue, this.topology, this.properties);
    }

    public final ImmutableRelationshipsLoadResult withTopology(Relationships.Topology value) {
        if (this.topology == value) {
            return this;
        }
        Relationships.Topology newValue = Objects.requireNonNull(value, "topology");
        return new ImmutableRelationshipsLoadResult(this, this.relationshipType, newValue, this.properties);
    }

    public final ImmutableRelationshipsLoadResult withProperties(Map<String, ? extends Relationships.Properties> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, Relationships.Properties> newValue = ImmutableRelationshipsLoadResult.createUnmodifiableMap(true, false, entries);
        return new ImmutableRelationshipsLoadResult(this, this.relationshipType, this.topology, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipsLoadResult && this.equalTo((ImmutableRelationshipsLoadResult)another);
    }

    private boolean equalTo(ImmutableRelationshipsLoadResult another) {
        return this.relationshipType.equals((Object)another.relationshipType) && this.topology.equals(another.topology) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relationshipType.hashCode();
        h += (h << 5) + this.topology.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipsLoadResult{relationshipType=" + this.relationshipType + ", topology=" + this.topology + ", properties=" + this.properties + "}";
    }

    public static GdlFactory.RelationshipsLoadResult of(RelationshipType relationshipType, Relationships.Topology topology, Map<String, ? extends Relationships.Properties> properties) {
        return new ImmutableRelationshipsLoadResult(relationshipType, topology, properties);
    }

    static GdlFactory.RelationshipsLoadResult copyOf(GdlFactory.RelationshipsLoadResult instance) {
        if (instance instanceof ImmutableRelationshipsLoadResult) {
            return (ImmutableRelationshipsLoadResult)instance;
        }
        return ImmutableRelationshipsLoadResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="GdlFactory.RelationshipsLoadResult", generator="Immutables")
    static final class Builder {
        private static final long INIT_BIT_RELATIONSHIP_TYPE = 1L;
        private static final long INIT_BIT_TOPOLOGY = 2L;
        private long initBits = 3L;
        private RelationshipType relationshipType;
        private Relationships.Topology topology;
        private Map<String, Relationships.Properties> properties = null;

        private Builder() {
        }

        public final Builder from(ImmutableRelationshipsLoadResult instance) {
            return this.from((GdlFactory.RelationshipsLoadResult)instance);
        }

        final Builder from(GdlFactory.RelationshipsLoadResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.relationshipType(instance.relationshipType());
            this.topology(instance.topology());
            this.putAllProperties(instance.properties());
            return this;
        }

        public final Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType = Objects.requireNonNull(relationshipType, "relationshipType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder topology(Relationships.Topology topology) {
            this.topology = Objects.requireNonNull(topology, "topology");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder putProperty(String key, Relationships.Properties value) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Relationships.Properties>();
            }
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, "properties value"));
            return this;
        }

        public final Builder putProperty(Map.Entry<String, ? extends Relationships.Properties> entry) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Relationships.Properties>();
            }
            String k = entry.getKey();
            Relationships.Properties v = entry.getValue();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            return this;
        }

        public final Builder properties(Map<String, ? extends Relationships.Properties> entries) {
            this.properties = new LinkedHashMap<String, Relationships.Properties>();
            return this.putAllProperties(entries);
        }

        public final Builder putAllProperties(Map<String, ? extends Relationships.Properties> entries) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Relationships.Properties>();
            }
            for (Map.Entry<String, ? extends Relationships.Properties> e : entries.entrySet()) {
                String k = e.getKey();
                Relationships.Properties v = e.getValue();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, "properties value"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.relationshipType = null;
            this.topology = null;
            if (this.properties != null) {
                this.properties.clear();
            }
            return this;
        }

        public GdlFactory.RelationshipsLoadResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelationshipsLoadResult(null, this.relationshipType, this.topology, this.properties == null ? Collections.emptyMap() : ImmutableRelationshipsLoadResult.createUnmodifiableMap(false, false, this.properties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relationshipType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("topology");
            }
            return "Cannot build RelationshipsLoadResult, some of required attributes are not set " + attributes;
        }
    }
}

