/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.graphbuilder;

import java.util.ArrayList;
import java.util.Random;
import org.neo4j.gds.graphbuilder.GraphBuilder;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class CompleteGraphBuilder
extends GraphBuilder<CompleteGraphBuilder> {
    CompleteGraphBuilder(GraphDatabaseAPI api, Transaction tx, Label label, RelationshipType relationship, Random random) {
        super(api, tx, label, relationship, random);
    }

    public CompleteGraphBuilder createCompleteGraph(int nodeCount) {
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (i = 0; i < nodeCount; ++i) {
            nodes.add(this.createNode());
        }
        for (i = 0; i < nodeCount; ++i) {
            for (int j = 0; j < nodeCount; ++j) {
                if (i == j) continue;
                this.createRelationship((Node)nodes.get(i), (Node)nodes.get(j));
            }
        }
        return this;
    }

    public CompleteGraphBuilder createCompleteGraph(int nodeCount, double connectedness) {
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (i = 0; i < nodeCount; ++i) {
            nodes.add(this.createNode());
        }
        for (i = 0; i < nodeCount; ++i) {
            for (int j = 0; j < nodeCount; ++j) {
                if (i == j || !(this.randomDouble() < connectedness)) continue;
                this.createRelationship((Node)nodes.get(i), (Node)nodes.get(j));
            }
        }
        return this;
    }

    @Override
    protected CompleteGraphBuilder me() {
        return this;
    }
}

