/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.graphbuilder;

import java.util.HashSet;
import java.util.Random;
import java.util.function.Consumer;
import org.neo4j.gds.graphbuilder.CompleteGraphBuilder;
import org.neo4j.gds.graphbuilder.DefaultBuilder;
import org.neo4j.gds.graphbuilder.GridBuilder;
import org.neo4j.gds.graphbuilder.RingBuilder;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public abstract class GraphBuilder<ME extends GraphBuilder<ME>>
implements AutoCloseable {
    private final ME self;
    protected final HashSet<Node> nodes;
    protected final HashSet<Relationship> relationships;
    private final GraphDatabaseAPI api;
    private final Transaction tx;
    private final Random random;
    protected Label label;
    protected RelationshipType relationship;

    protected GraphBuilder(GraphDatabaseAPI api, Transaction tx, Label label, RelationshipType relationship, Random random) {
        this.api = api;
        this.tx = tx;
        this.label = label;
        this.relationship = relationship;
        this.nodes = new HashSet();
        this.relationships = new HashSet();
        this.self = this.me();
        this.random = random;
    }

    public ME setLabel(String label) {
        if (null == label) {
            return this.self;
        }
        this.label = Label.label((String)label);
        return this.self;
    }

    public ME setRelationship(String relationship) {
        if (null == relationship) {
            return this.self;
        }
        this.relationship = RelationshipType.withName((String)relationship);
        return this.self;
    }

    public Relationship createRelationship(Node p, Node q) {
        Relationship relationshipTo = p.createRelationshipTo(q, this.relationship);
        this.relationships.add(relationshipTo);
        return relationshipTo;
    }

    public Node createNode() {
        Node node = this.tx.createNode();
        if (null != this.label) {
            node.addLabel(this.label);
        }
        this.nodes.add(node);
        return node;
    }

    public ME forEachNodeInTx(Consumer<Node> consumer) {
        this.nodes.forEach(consumer);
        return this.self;
    }

    public ME forEachRelInTx(Consumer<Relationship> consumer) {
        this.relationships.forEach(consumer);
        return this.self;
    }

    public DefaultBuilder newDefaultBuilder() {
        return new DefaultBuilder(this.api, this.tx, this.label, this.relationship, this.random);
    }

    public RingBuilder newRingBuilder() {
        return new RingBuilder(this.api, this.tx, this.label, this.relationship, this.random);
    }

    public GridBuilder newGridBuilder() {
        return new GridBuilder(this.api, this.tx, this.label, this.relationship, this.random);
    }

    public CompleteGraphBuilder newCompleteGraphBuilder() {
        return new CompleteGraphBuilder(this.api, this.tx, this.label, this.relationship, this.random);
    }

    protected double randomDouble() {
        return this.random.nextDouble();
    }

    protected abstract ME me();

    public static DefaultBuilder create(GraphDatabaseAPI api) {
        return new DefaultBuilder(api, api.beginTx(), null, null, RNGHolder.rng);
    }

    public static DefaultBuilder create(GraphDatabaseAPI api, Random random) {
        return new DefaultBuilder(api, api.beginTx(), null, null, random);
    }

    @Override
    public void close() {
        this.tx.commit();
        this.tx.close();
    }

    private static final class RNGHolder {
        static final Random rng = new Random();

        private RNGHolder() {
        }
    }
}

