/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.graphbuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.neo4j.gds.graphbuilder.GraphBuilder;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GridBuilder
extends GraphBuilder<GridBuilder> {
    private final List<List<Node>> lines = new ArrayList<List<Node>>();

    GridBuilder(GraphDatabaseAPI api, Transaction tx, Label label, RelationshipType relationship, Random random) {
        super(api, tx, label, relationship, random);
    }

    public GridBuilder createGrid(int width, int height) {
        return this.createGrid(width, height, 1.0);
    }

    public GridBuilder createGrid(int width, int height, double connectivity) {
        List<Node> temp = null;
        for (int i = 0; i < height; ++i) {
            List<Node> line = this.createLine(width);
            if (null != temp) {
                for (int j = 0; j < width; ++j) {
                    if (!(this.randomDouble() < connectivity)) continue;
                    this.createRelationship(temp.get(j), line.get(j));
                }
            }
            temp = line;
        }
        return this;
    }

    private List<Node> createLine(int length) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node temp = this.createNode();
        for (int i = 1; i < length; ++i) {
            Node node = this.createNode();
            nodes.add(temp);
            this.createRelationship(temp, node);
            temp = node;
        }
        nodes.add(temp);
        this.lines.add(nodes);
        return nodes;
    }

    public List<List<Node>> getLineNodes() {
        return this.lines;
    }

    @Override
    protected GridBuilder me() {
        return this;
    }
}

