/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.graphbuilder;

import java.util.Random;
import org.neo4j.gds.graphbuilder.GraphBuilder;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class RingBuilder
extends GraphBuilder<RingBuilder> {
    RingBuilder(GraphDatabaseAPI api, Transaction tx, Label label, RelationshipType relationship, Random random) {
        super(api, tx, label, relationship, random);
    }

    public RingBuilder createRing(int size) {
        Node head;
        if (size < 2) {
            throw new IllegalArgumentException("size must be >= 2");
        }
        Node temp = head = this.createNode();
        for (int i = 1; i < size; ++i) {
            Node node = this.createNode();
            this.createRelationship(temp, node);
            temp = node;
        }
        this.createRelationship(temp, head);
        return this;
    }

    @Override
    protected RingBuilder me() {
        return this;
    }
}

