/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.graphbuilder;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.TransactionTerminatedException;

public final class TransactionTerminationTestUtils {
    private static final long CI_SMEAR = 10L;

    public static void assertTerminates(Consumer<TerminationFlag> algoRunner, long terminateAfterMillis, long maxDelayMillis) {
        final TestTerminationFlag terminationFlag = new TestTerminationFlag();
        final AtomicLong terminationTime = new AtomicLong();
        Assertions.assertThrows(TransactionTerminatedException.class, () -> {
            new Timer(true).schedule(new TimerTask(){

                @Override
                public void run() {
                    terminationTime.set(System.nanoTime());
                    terminationFlag.stop();
                }
            }, terminateAfterMillis);
            algoRunner.accept(terminationFlag);
        });
        long terminatedAt = System.nanoTime();
        long terminationDelay = terminatedAt - terminationTime.get();
        long terminationDelayMillis = TimeUnit.NANOSECONDS.toMillis(terminationDelay);
        if ((System.getenv("TEAMCITY_VERSION") != null || System.getenv("CI") != null || System.getenv("BUILD_ID") != null) && (maxDelayMillis *= 10L) < 0L) {
            maxDelayMillis = Long.MAX_VALUE;
        }
        Assertions.assertTrue((terminationDelayMillis <= maxDelayMillis ? 1 : 0) != 0, (String)StringFormatting.formatWithLocale((String)"Expected to terminate after at most %dms but took %dms", (Object[])new Object[]{maxDelayMillis, terminationDelayMillis}));
    }

    private TransactionTerminationTestUtils() {
    }

    static class TestTerminationFlag
    implements TerminationFlag {
        private boolean running = true;

        TestTerminationFlag() {
        }

        void stop() {
            this.running = false;
        }

        public boolean running() {
            return this.running;
        }
    }
}

