/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.junit.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers.AnnotationHelper;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.Neo4jVersion;
import org.neo4j.gds.junit.annotation.DisableForNeo4jVersion;
import org.neo4j.gds.junit.annotation.DisableForNeo4jVersions;
import org.neo4j.gds.utils.StringFormatting;

public class DisableForNeo4jVersionCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@DisableForNeo4jVersion is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        DisableForNeo4jVersions repeated;
        AnnotatedElement element = (AnnotatedElement)context.getElement().orElseThrow(IllegalStateException::new);
        DisableForNeo4jVersion single = (DisableForNeo4jVersion)AnnotationHelper.findAnnotation((AnnotatedElement)element, DisableForNeo4jVersion.class);
        DisableForNeo4jVersion[] annotations = single != null ? new DisableForNeo4jVersion[]{single} : ((repeated = (DisableForNeo4jVersions)AnnotationHelper.findAnnotation((AnnotatedElement)element, DisableForNeo4jVersions.class)) != null ? repeated.value() : new DisableForNeo4jVersion[]{});
        return this.shouldDisableForNeo4jVersion(Arrays.asList(annotations), element);
    }

    private ConditionEvaluationResult shouldDisableForNeo4jVersion(Iterable<DisableForNeo4jVersion> annotations, AnnotatedElement element) {
        Neo4jVersion currentNeo4jVersion = GraphDatabaseApiProxy.neo4jVersion();
        for (DisableForNeo4jVersion annotation : annotations) {
            Neo4jVersion excludedNeo4jVersion = annotation.value();
            if (currentNeo4jVersion != excludedNeo4jVersion) continue;
            String message = annotation.message();
            if (message.isBlank()) {
                message = StringFormatting.formatWithLocale((String)"%s should be disabled for Neo4j %s", (Object[])new Object[]{element.toString(), excludedNeo4jVersion.toString()});
            }
            return ConditionEvaluationResult.disabled((String)message);
        }
        return ENABLED_BY_DEFAULT;
    }
}

