/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.junit.annotation;

import java.lang.reflect.AnnotatedElement;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.shadow.com.univocity.parsers.annotations.helpers.AnnotationHelper;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.Neo4jVersion;
import org.neo4j.gds.junit.annotation.EnableForNeo4jVersion;
import org.neo4j.gds.utils.StringFormatting;

public class EnableForNeo4jVersionCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@EnableForNeo4jVersion is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AnnotatedElement element = (AnnotatedElement)context.getElement().orElseThrow(IllegalStateException::new);
        Neo4jVersion runningNeo4jVersion = GraphDatabaseApiProxy.neo4jVersion();
        EnableForNeo4jVersion single = (EnableForNeo4jVersion)AnnotationHelper.findAnnotation((AnnotatedElement)element, EnableForNeo4jVersion.class);
        if (single != null && single.value() != runningNeo4jVersion) {
            return ConditionEvaluationResult.disabled((String)StringFormatting.formatWithLocale((String)"Not enabled for %s, only for Neo4j version %s", (Object[])new Object[]{runningNeo4jVersion, single.value()}));
        }
        return ENABLED_BY_DEFAULT;
    }
}

