/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.model.catalog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.model.ModelConfig;
import org.neo4j.gds.model.catalog.TestTrainConfig;

@Generated(from="TestTrainConfig", generator="Immutables")
public final class ImmutableTestTrainConfig
implements TestTrainConfig {
    @Nullable
    private final String usernameOverride;
    private final boolean sudo;
    private final Collection<String> configKeys;
    private final Map<String, Object> toMap;
    private final String modelName;
    private final String username;
    private final String dummyConfigProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 66L;

    private ImmutableTestTrainConfig(String modelName, String username, String dummyConfigProperty) {
        this.modelName = Objects.requireNonNull(modelName, "modelName");
        this.initShim.username(Objects.requireNonNull(username, "username"));
        this.initShim.dummyConfigProperty(Objects.requireNonNull(dummyConfigProperty, "dummyConfigProperty"));
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.username = this.initShim.username();
        this.dummyConfigProperty = this.initShim.dummyConfigProperty();
        this.initShim = null;
    }

    private ImmutableTestTrainConfig(Builder builder) {
        this.modelName = builder.modelName;
        if (builder.usernameOverrideIsSet()) {
            this.initShim.usernameOverride(builder.usernameOverride);
        }
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.username != null) {
            this.initShim.username(builder.username);
        }
        if (builder.dummyConfigProperty != null) {
            this.initShim.dummyConfigProperty(builder.dummyConfigProperty);
        }
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.username = this.initShim.username();
        this.dummyConfigProperty = this.initShim.dummyConfigProperty();
        this.initShim = null;
    }

    private ImmutableTestTrainConfig(@Nullable String usernameOverride, boolean sudo, Collection<String> configKeys, String modelName, String username, String dummyConfigProperty) {
        this.initShim.usernameOverride(usernameOverride);
        this.initShim.sudo(sudo);
        this.initShim.configKeys(configKeys);
        this.modelName = modelName;
        this.initShim.username(username);
        this.initShim.dummyConfigProperty(dummyConfigProperty);
        this.usernameOverride = this.initShim.usernameOverride();
        this.sudo = this.initShim.sudo();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.username = this.initShim.username();
        this.dummyConfigProperty = this.initShim.dummyConfigProperty();
        this.initShim = null;
    }

    @Nullable
    private String usernameOverrideInitialize() {
        return TestTrainConfig.super.usernameOverride();
    }

    private boolean sudoInitialize() {
        return TestTrainConfig.super.sudo();
    }

    private Collection<String> configKeysInitialize() {
        return TestTrainConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return TestTrainConfig.super.toMap();
    }

    private String usernameInitialize() {
        return TestTrainConfig.super.username();
    }

    private String dummyConfigPropertyInitialize() {
        return TestTrainConfig.super.dummyConfigProperty();
    }

    @Nullable
    public String usernameOverride() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usernameOverride() : this.usernameOverride;
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public String modelName() {
        return this.modelName;
    }

    public String username() {
        InitShim shim = this.initShim;
        return shim != null ? shim.username() : this.username;
    }

    @Override
    public String dummyConfigProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dummyConfigProperty() : this.dummyConfigProperty;
    }

    public final ImmutableTestTrainConfig withUsernameOverride(@Nullable String value) {
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return new ImmutableTestTrainConfig(value, this.sudo, this.configKeys, this.modelName, this.username, this.dummyConfigProperty);
    }

    public final ImmutableTestTrainConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return new ImmutableTestTrainConfig(this.usernameOverride, value, this.configKeys, this.modelName, this.username, this.dummyConfigProperty);
    }

    public final ImmutableTestTrainConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return new ImmutableTestTrainConfig(this.usernameOverride, this.sudo, newValue, this.modelName, this.username, this.dummyConfigProperty);
    }

    public final ImmutableTestTrainConfig withModelName(String value) {
        String newValue = Objects.requireNonNull(value, "modelName");
        if (this.modelName.equals(newValue)) {
            return this;
        }
        return new ImmutableTestTrainConfig(this.usernameOverride, this.sudo, this.configKeys, newValue, this.username, this.dummyConfigProperty);
    }

    public final ImmutableTestTrainConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableTestTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.modelName, newValue, this.dummyConfigProperty);
    }

    public final ImmutableTestTrainConfig withDummyConfigProperty(String value) {
        String newValue = Objects.requireNonNull(value, "dummyConfigProperty");
        if (this.dummyConfigProperty.equals(newValue)) {
            return this;
        }
        return new ImmutableTestTrainConfig(this.usernameOverride, this.sudo, this.configKeys, this.modelName, this.username, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTestTrainConfig && this.equalTo((ImmutableTestTrainConfig)another);
    }

    private boolean equalTo(ImmutableTestTrainConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.modelName.equals(another.modelName) && this.username.equals(another.username) && this.dummyConfigProperty.equals(another.dummyConfigProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + this.modelName.hashCode();
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.dummyConfigProperty.hashCode();
        return h;
    }

    public String toString() {
        return "TestTrainConfig{usernameOverride=" + this.usernameOverride + ", sudo=" + this.sudo + ", modelName=" + this.modelName + ", username=" + this.username + ", dummyConfigProperty=" + this.dummyConfigProperty + "}";
    }

    public static TestTrainConfig of(String modelName, String username, String dummyConfigProperty) {
        return new ImmutableTestTrainConfig(modelName, username, dummyConfigProperty);
    }

    public static TestTrainConfig copyOf(TestTrainConfig instance) {
        if (instance instanceof ImmutableTestTrainConfig) {
            return (ImmutableTestTrainConfig)instance;
        }
        return ImmutableTestTrainConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TestTrainConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MODEL_NAME = 1L;
        private static final long OPT_BIT_USERNAME_OVERRIDE = 1L;
        private static final long OPT_BIT_SUDO = 2L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private Collection<String> configKeys;
        private String modelName;
        private String username;
        private String dummyConfigProperty;

        private Builder() {
        }

        public final Builder from(TestTrainConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ModelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TestTrainConfig instance;
            if (object instanceof TestTrainConfig) {
                instance = (TestTrainConfig)object;
                this.dummyConfigProperty(instance.dummyConfigProperty());
            }
            if (object instanceof ModelConfig) {
                instance = (ModelConfig)object;
                this.modelName(instance.modelName());
                this.username(instance.username());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                @Nullable String usernameOverrideValue = instance.usernameOverride();
                if (usernameOverrideValue != null) {
                    this.usernameOverride(usernameOverrideValue);
                }
                this.configKeys(instance.configKeys());
                this.sudo(instance.sudo());
            }
        }

        public final Builder usernameOverride(@Nullable String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.optBits |= 1L;
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder modelName(String modelName) {
            this.modelName = Objects.requireNonNull(modelName, "modelName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        public final Builder dummyConfigProperty(String dummyConfigProperty) {
            this.dummyConfigProperty = Objects.requireNonNull(dummyConfigProperty, "dummyConfigProperty");
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.configKeys = null;
            this.modelName = null;
            this.username = null;
            this.dummyConfigProperty = null;
            return this;
        }

        public TestTrainConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTestTrainConfig(this);
        }

        private boolean usernameOverrideIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sudoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("modelName");
            }
            return "Cannot build TestTrainConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="TestTrainConfig", generator="Immutables")
    private final class InitShim {
        private byte usernameOverrideBuildStage = 0;
        private String usernameOverride;
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte usernameBuildStage = 0;
        private String username;
        private byte dummyConfigPropertyBuildStage = 0;
        private String dummyConfigProperty;

        private InitShim() {
        }

        String usernameOverride() {
            if (this.usernameOverrideBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameOverrideBuildStage == 0) {
                this.usernameOverrideBuildStage = (byte)-1;
                this.usernameOverride = ImmutableTestTrainConfig.this.usernameOverrideInitialize();
                this.usernameOverrideBuildStage = 1;
            }
            return this.usernameOverride;
        }

        void usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            this.usernameOverrideBuildStage = 1;
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableTestTrainConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableTestTrainConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableTestTrainConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        String username() {
            if (this.usernameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usernameBuildStage == 0) {
                this.usernameBuildStage = (byte)-1;
                this.username = Objects.requireNonNull(ImmutableTestTrainConfig.this.usernameInitialize(), "username");
                this.usernameBuildStage = 1;
            }
            return this.username;
        }

        void username(String username) {
            this.username = username;
            this.usernameBuildStage = 1;
        }

        String dummyConfigProperty() {
            if (this.dummyConfigPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dummyConfigPropertyBuildStage == 0) {
                this.dummyConfigPropertyBuildStage = (byte)-1;
                this.dummyConfigProperty = Objects.requireNonNull(ImmutableTestTrainConfig.this.dummyConfigPropertyInitialize(), "dummyConfigProperty");
                this.dummyConfigPropertyBuildStage = 1;
            }
            return this.dummyConfigProperty;
        }

        void dummyConfigProperty(String dummyConfigProperty) {
            this.dummyConfigProperty = dummyConfigProperty;
            this.dummyConfigPropertyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.usernameOverrideBuildStage == -1) {
                attributes.add("usernameOverride");
            }
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.usernameBuildStage == -1) {
                attributes.add("username");
            }
            if (this.dummyConfigPropertyBuildStage == -1) {
                attributes.add("dummyConfigProperty");
            }
            return "Cannot build TestTrainConfig, attribute initializers form cycle " + attributes;
        }
    }
}

