/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.model.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.model.ModelConfig;
import org.neo4j.gds.model.catalog.TestTrainConfig;

public final class TestTrainConfigImpl
implements TestTrainConfig {
    private String dummyConfigProperty;
    @Nullable
    private String usernameOverride;
    private boolean sudo;
    private String modelName;
    private String username;

    public TestTrainConfigImpl(@NotNull String username, @NotNull CypherMapWrapper config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.dummyConfigProperty = (String)CypherMapWrapper.failOnNull((String)"dummyConfigProperty", (Object)config.getString("dummyConfigProperty", TestTrainConfig.super.dummyConfigProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = StringUtils.trimToNull((String)config.getString("username", TestTrainConfig.super.usernameOverride()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", TestTrainConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.modelName = (String)CypherMapWrapper.failOnNull((String)"modelName", (Object)ModelConfig.validateName((String)config.requireString("modelName")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.username = (String)CypherMapWrapper.failOnNull((String)"username", (Object)username);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public String dummyConfigProperty() {
        return this.dummyConfigProperty;
    }

    @Nullable
    public String usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("dummyConfigProperty", "username", "sudo", "modelName");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("dummyConfigProperty", this.dummyConfigProperty());
        map.put("username", this.usernameOverride());
        map.put("sudo", this.sudo());
        map.put("modelName", this.modelName());
        return map;
    }

    public String modelName() {
        return this.modelName;
    }

    public String username() {
        return this.username;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();
        @NotNull
        private String username;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder dummyConfigProperty(String dummyConfigProperty) {
            this.config.put("dummyConfigProperty", dummyConfigProperty);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder modelName(String modelName) {
            this.config.put("modelName", modelName);
            return this;
        }

        public TestTrainConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new TestTrainConfigImpl(this.username, config);
        }
    }
}

