/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.transaction;

import java.util.Arrays;
import java.util.function.Consumer;
import org.junit.jupiter.api.BeforeEach;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gds.BaseTest;
import org.neo4j.gds.compat.FilterAccessMode;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.gds.transaction.SecurityContextWrapper;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

public abstract class TransactionContextTest
extends BaseTest {
    @BeforeEach
    void setUp() {
        this.db.executeTransactionally("CREATE (n:Node1 {prop1: 42}), (o:Node2 {prop2: 1337}), (n)-[:REL {prop3: 23}]->(o)");
    }

    protected AccessMode forbiddenLabel(String label) throws KernelException {
        int forbiddenToken;
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = GraphDatabaseApiProxy.kernelTransaction((Transaction)tx);
            forbiddenToken = ktx.tokenWrite().labelGetOrCreateForName(label);
        }
        return new FilterAccessMode(){

            public boolean allowsTraverseAllLabels() {
                return false;
            }

            public boolean allowTraverseAllNodesWithLabel(long label1) {
                return label1 != (long)forbiddenToken;
            }

            public boolean allowsTraverseNode(long ... labels) {
                return Arrays.stream(labels).noneMatch(l -> l == (long)forbiddenToken);
            }
        }.toNeoAccessMode();
    }

    protected AccessMode forbiddenNodes() {
        return new FilterAccessMode(){

            public boolean allowsTraverseAllLabels() {
                return false;
            }

            public boolean allowTraverseAllNodesWithLabel(long label) {
                return false;
            }

            public boolean allowsTraverseNode(long ... labels) {
                return false;
            }
        }.toNeoAccessMode();
    }

    protected AccessMode forbiddenRelationships() {
        return new FilterAccessMode(){

            public boolean allowsTraverseRelType(int relType) {
                return false;
            }
        }.toNeoAccessMode();
    }

    protected AccessMode forbiddenProperty(String property) throws KernelException {
        int forbiddenToken;
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = GraphDatabaseApiProxy.kernelTransaction((Transaction)tx);
            forbiddenToken = ktx.tokenWrite().propertyKeyGetOrCreateForName(property);
        }
        return new FilterAccessMode(){

            public boolean allowsReadNodeProperty(int propertyKey) {
                return propertyKey != forbiddenToken;
            }
        }.toNeoAccessMode();
    }

    protected void applyTxWithAccessMode(Consumer<Transaction> txConsumer, AccessMode noNodesAllowed) {
        SecurityContextWrapper securityContextService = (SecurityContextWrapper)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)this.db, SecurityContextWrapper.class);
        try (Transaction topLevelTx = this.db.beginTx();){
            SecurityContext securityContext = Neo4jProxy.securityContext((String)"", (AuthSubject)AuthSubject.ANONYMOUS, (AccessMode)noNodesAllowed, (String)this.db.databaseName());
            ((InternalTransaction)topLevelTx).kernelTransaction().overrideWith(securityContextService.wrap(securityContext));
            txConsumer.accept(topLevelTx);
        }
    }
}

