/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.transaction;

import org.neo4j.gds.compat.Neo4jProxy;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;

public final class TransactionContext {
    private final GraphDatabaseService databaseService;
    private final SecurityContext securityContext;

    public static TransactionContext of(GraphDatabaseService databaseService, Transaction top) {
        InternalTransaction internalTransaction = (InternalTransaction)top;
        return TransactionContext.of(databaseService, internalTransaction);
    }

    public static TransactionContext of(GraphDatabaseService databaseService, InternalTransaction top) {
        return TransactionContext.of(databaseService, top.securityContext());
    }

    public static TransactionContext of(GraphDatabaseService databaseService, SecurityContext securityContext) {
        return new TransactionContext(databaseService, securityContext);
    }

    private TransactionContext(GraphDatabaseService databaseService, SecurityContext securityContext) {
        this.databaseService = databaseService;
        this.securityContext = securityContext;
    }

    public String username() {
        return Neo4jProxy.username((AuthSubject)this.securityContext.subject());
    }

    public <T, E extends Exception> T apply(TxFunction<T, E> block) throws E {
        Transaction tx = this.databaseService.beginTx();
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        ktx.overrideWith(this.securityContext);
        try (Transaction transaction = tx;){
            T result = block.apply(tx, ktx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public <E extends Exception> void accept(TxConsumer<E> block) throws E {
        Transaction tx = this.databaseService.beginTx();
        KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
        ktx.overrideWith(this.securityContext);
        try (Transaction transaction = tx;){
            block.accept(tx, ktx);
            tx.commit();
        }
    }

    public TransactionContext withRestrictedAccess(AccessMode.Static accessMode) {
        RestrictedAccessMode restrictedMode = new RestrictedAccessMode(this.securityContext.mode(), accessMode);
        SecurityContext newContext = this.securityContext.withMode((AccessMode)restrictedMode);
        return new TransactionContext(this.databaseService, newContext);
    }

    public SecureTransaction fork() {
        InternalTransaction tx = (InternalTransaction)this.databaseService.beginTx();
        tx.kernelTransaction().overrideWith(this.securityContext);
        return new SecureTransaction(tx);
    }

    public static final class SecureTransaction
    implements AutoCloseable {
        private final InternalTransaction tx;

        private SecureTransaction(InternalTransaction tx) {
            this.tx = tx;
        }

        public KernelTransaction kernelTransaction() {
            return this.tx.kernelTransaction();
        }

        @Override
        public void close() {
            this.tx.close();
        }
    }

    public static interface TxFunction<T, E extends Exception> {
        public T apply(Transaction var1, KernelTransaction var2) throws E;
    }

    public static interface TxConsumer<E extends Exception> {
        public void accept(Transaction var1, KernelTransaction var2) throws E;
    }
}

