/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.utils.AtomicDoubleArray;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.AtomicDoubleArrayTranslator;
import org.neo4j.graphalgo.core.write.DoubleArrayTranslator;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.BetweennessCentrality;
import org.neo4j.graphalgo.impl.BetweennessCentralitySuccessorBrandes;
import org.neo4j.graphalgo.impl.ParallelBetweennessCentrality;
import org.neo4j.graphalgo.results.BetweennessCentralityProcResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BetweennessCentralityProc {
    public static final String DEFAULT_TARGET_PROPERTY = "centrality";
    public static final Direction DEFAULT_DIRECTION = Direction.OUTGOING;
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.betweenness.exp1.stream")
    @Description(value="CALL algo.betweenness.exp1.stream(label:String, relationship:String, {direction:'out', scaleFactor:100000}) YIELD nodeId, centrality - yields centrality for each node")
    public Stream<BetweennessCentrality.Result> betweennessSuccessorBrandesStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutNodeProperties().withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        BetweennessCentralitySuccessorBrandes algo = ((BetweennessCentralitySuccessorBrandes)((BetweennessCentralitySuccessorBrandes)new BetweennessCentralitySuccessorBrandes(graph, configuration.getNumber("scaleFactor", 100000).intValue(), Pools.DEFAULT).withTerminationFlag(TerminationFlag.wrap(this.transaction))).withProgressLogger(ProgressLogger.wrap(this.log, "BetweennessCentrality"))).withDirection(Direction.OUTGOING).compute();
        graph.release();
        return algo.resultStream();
    }

    @Procedure(value="algo.betweenness.stream")
    @Description(value="CALL algo.betweenness.stream(label:String, relationship:String, {direction:'out', concurrency :4})YIELD nodeId, centrality - yields centrality for each node")
    public Stream<BetweennessCentrality.Result> betweennessStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutNodeProperties().withDirection(configuration.getDirection(DEFAULT_DIRECTION)).load(configuration.getGraphImpl());
        int concurrency = configuration.getConcurrency();
        if (concurrency > 1) {
            int scaleFactor = configuration.getNumber("scaleFactor", 100000).intValue();
            ParallelBetweennessCentrality algo = ((ParallelBetweennessCentrality)((ParallelBetweennessCentrality)new ParallelBetweennessCentrality(graph, scaleFactor, Pools.DEFAULT, concurrency).withProgressLogger(ProgressLogger.wrap(this.log, "BetweennessCentrality"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).withDirection(configuration.getDirection(DEFAULT_DIRECTION)).compute();
            graph.release();
            return algo.resultStream();
        }
        BetweennessCentrality compute = new BetweennessCentrality(graph).withDirection(configuration.getDirection(DEFAULT_DIRECTION)).compute();
        graph.release();
        return compute.resultStream();
    }

    @Procedure(value="algo.betweenness.exp1", mode=Mode.WRITE)
    @Description(value="CALL algo.betweenness.exp1(label:String, relationship:String, {direction:'out', write:true, writeProperty:'centrality', stats:true, scaleFactor:100000}) YIELD loadMillis, computeMillis, writeMillis, nodes, minCentrality, maxCentrality, sumCentrality] - yields status of evaluation")
    public Stream<BetweennessCentralityProcResult> betweennessSucessorBrandes(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Graph graph;
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        BetweennessCentralityProcResult.Builder builder = BetweennessCentralityProcResult.builder();
        try (ProgressTimer timer = builder.timeLoad();){
            graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutNodeProperties().withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        }
        builder.withNodeCount(graph.nodeCount());
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        BetweennessCentralitySuccessorBrandes bc = (BetweennessCentralitySuccessorBrandes)((BetweennessCentralitySuccessorBrandes)new BetweennessCentralitySuccessorBrandes(graph, configuration.getNumber("scaleFactor", 100000).doubleValue(), Pools.DEFAULT).withDirection(Direction.OUTGOING).withProgressLogger(ProgressLogger.wrap(this.log, "BetweennessCentrality"))).withTerminationFlag(terminationFlag);
        builder.timeEval(() -> {
            bc.compute();
            if (configuration.isStatsFlag()) {
                this.computeStats(builder, bc.getCentrality());
            }
        });
        AtomicDoubleArray centrality = bc.getCentrality();
        bc.release();
        graph.release();
        if (configuration.isWriteFlag()) {
            String writeProperty = configuration.getWriteProperty(DEFAULT_TARGET_PROPERTY);
            builder.timeWrite(() -> Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build().write(writeProperty, centrality, AtomicDoubleArrayTranslator.INSTANCE));
        }
        return Stream.of(builder.build());
    }

    @Procedure(value="algo.betweenness", mode=Mode.WRITE)
    @Description(value="CALL algo.betweenness(label:String, relationship:String, {direction:'out',write:true, writeProperty:'centrality', stats:true, concurrency:4}) YIELD loadMillis, computeMillis, writeMillis, nodes, minCentrality, maxCentrality, sumCentrality - yields status of evaluation")
    public Stream<BetweennessCentralityProcResult> betweenness(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        if (configuration.getConcurrency() > 1) {
            return this.computeBetweennessParallel(label, relationship, configuration);
        }
        return this.computeBetweenness(label, relationship, configuration);
    }

    public Stream<BetweennessCentralityProcResult> computeBetweenness(String label, String relationship, ProcedureConfiguration configuration) {
        Graph graph;
        BetweennessCentralityProcResult.Builder builder = BetweennessCentralityProcResult.builder();
        try (ProgressTimer timer = builder.timeLoad();){
            graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutNodeProperties().withDirection(configuration.getDirection(Direction.OUTGOING)).load(configuration.getGraphImpl());
        }
        builder.withNodeCount(graph.nodeCount());
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        BetweennessCentrality bc = ((BetweennessCentrality)((BetweennessCentrality)new BetweennessCentrality(graph).withTerminationFlag(terminationFlag)).withProgressLogger(ProgressLogger.wrap(this.log, "BetweennessCentrality(sequential)"))).withDirection(configuration.getDirection(Direction.OUTGOING));
        builder.timeEval(() -> {
            bc.compute();
            if (configuration.isStatsFlag()) {
                this.computeStats(builder, bc.getCentrality());
            }
        });
        double[] centrality = bc.getCentrality();
        bc.release();
        graph.release();
        if (configuration.isWriteFlag()) {
            String writeProperty = configuration.getWriteProperty(DEFAULT_TARGET_PROPERTY);
            builder.timeWrite(() -> Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build().write(writeProperty, centrality, DoubleArrayTranslator.INSTANCE));
        }
        return Stream.of(builder.build());
    }

    public Stream<BetweennessCentralityProcResult> computeBetweennessParallel(String label, String relationship, ProcedureConfiguration configuration) {
        Graph graph;
        BetweennessCentralityProcResult.Builder builder = BetweennessCentralityProcResult.builder();
        try (ProgressTimer timer = builder.timeLoad();){
            graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutNodeProperties().withDirection(configuration.getDirection(Direction.OUTGOING)).load(configuration.getGraphImpl());
        }
        builder.withNodeCount(graph.nodeCount());
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        ParallelBetweennessCentrality bc = ((ParallelBetweennessCentrality)((ParallelBetweennessCentrality)new ParallelBetweennessCentrality(graph, configuration.getNumber("scaleFactor", 100000).doubleValue(), Pools.DEFAULT, configuration.getConcurrency()).withProgressLogger(ProgressLogger.wrap(this.log, "BetweennessCentrality(parallel)"))).withTerminationFlag(terminationFlag)).withDirection(configuration.getDirection(Direction.OUTGOING));
        builder.timeEval(() -> {
            bc.compute();
            if (configuration.isStatsFlag()) {
                this.computeStats(builder, bc.getCentrality());
            }
        });
        graph.release();
        if (configuration.isWriteFlag()) {
            builder.timeWrite(() -> {
                AtomicDoubleArray centrality = bc.getCentrality();
                String writeProperty = configuration.getWriteProperty(DEFAULT_TARGET_PROPERTY);
                Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build().write(writeProperty, centrality, AtomicDoubleArrayTranslator.INSTANCE);
            });
        }
        bc.release();
        return Stream.of(builder.build());
    }

    private void computeStats(BetweennessCentralityProcResult.Builder builder, double[] centrality) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double sum = 0.0;
        for (int i = centrality.length - 1; i >= 0; --i) {
            double c = centrality[i];
            if (c < min) {
                min = c;
            }
            if (c > max) {
                max = c;
            }
            sum += c;
        }
        builder.withCentralityMax(max).withCentralityMin(min).withCentralitySum(sum);
    }

    private void computeStats(BetweennessCentralityProcResult.Builder builder, AtomicDoubleArray centrality) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double sum = 0.0;
        for (int i = centrality.length() - 1; i >= 0; --i) {
            double c = centrality.get(i);
            if (c < min) {
                min = c;
            }
            if (c > max) {
                max = c;
            }
            sum += c;
        }
        builder.withCentralityMax(max).withCentralityMin(min).withCentralitySum(sum);
    }
}

