/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.HugeGraph;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.HugeMSClosenessCentrality;
import org.neo4j.graphalgo.impl.MSBFSCCAlgorithm;
import org.neo4j.graphalgo.impl.MSClosenessCentrality;
import org.neo4j.graphalgo.results.ClosenessCentralityProcResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ClosenessCentralityProc {
    public static final String DEFAULT_TARGET_PROPERTY = "centrality";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.closeness.stream")
    @Description(value="CALL algo.closeness.stream(label:String, relationship:String{concurrency:4}) YIELD nodeId, centrality - yields centrality for each node")
    public Stream<MSClosenessCentrality.Result> closenessStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        AllocationTracker tracker = AllocationTracker.create();
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutNodeProperties().withConcurrency(configuration.getConcurrency()).withDirection(Direction.OUTGOING).withAllocationTracker(tracker).load(configuration.getGraphImpl());
        MSBFSCCAlgorithm<?> algo = this.newAlgo(tracker, graph, configuration.getConcurrency());
        ((MSBFSCCAlgorithm)algo.withProgressLogger(ProgressLogger.wrap(this.log, "ClosenessCentrality(MultiSource)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction));
        algo.compute();
        graph.release();
        return algo.resultStream();
    }

    private MSBFSCCAlgorithm<?> newAlgo(AllocationTracker tracker, Graph graph, int concurrency) {
        MSBFSCCAlgorithm algo;
        if (graph instanceof HugeGraph) {
            HugeGraph hugeGraph = (HugeGraph)graph;
            algo = new HugeMSClosenessCentrality(hugeGraph, tracker, concurrency, Pools.DEFAULT);
        } else {
            algo = new MSClosenessCentrality(graph, concurrency, Pools.DEFAULT);
        }
        return algo;
    }

    @Procedure(value="algo.closeness", mode=Mode.WRITE)
    @Description(value="CALL algo.closeness(label:String, relationship:String, {write:true, writeProperty:'centrality, concurrency:4'}) YIELD loadMillis, computeMillis, writeMillis, nodes] - yields evaluation details")
    public Stream<ClosenessCentralityProcResult> closeness(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Graph graph;
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        ClosenessCentralityProcResult.Builder builder = ClosenessCentralityProcResult.builder();
        AllocationTracker tracker = AllocationTracker.create();
        int concurrency = configuration.getConcurrency();
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        try (ProgressTimer timer = builder.timeLoad();){
            graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutNodeProperties().withConcurrency(concurrency).withDirection(Direction.OUTGOING).withAllocationTracker(tracker).load(configuration.getGraphImpl());
        }
        builder.withNodeCount(graph.nodeCount());
        MSBFSCCAlgorithm<?> algo = this.newAlgo(tracker, graph, concurrency);
        ((MSBFSCCAlgorithm)algo.withProgressLogger(ProgressLogger.wrap(this.log, "ClosenessCentrality(MultiSource)"))).withTerminationFlag(terminationFlag);
        builder.timeEval(algo::compute);
        if (configuration.isWriteFlag()) {
            graph.release();
            String writeProperty = configuration.getWriteProperty(DEFAULT_TARGET_PROPERTY);
            builder.timeWrite(() -> {
                Exporter exporter = Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, concurrency, terminationFlag).build();
                algo.export(writeProperty, exporter);
            });
            algo.release();
        }
        return Stream.of(builder.build());
    }
}

