/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.heavyweight.HeavyGraph;
import org.neo4j.graphalgo.core.heavyweight.HeavyGraphFactory;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.core.write.IntArrayTranslator;
import org.neo4j.graphalgo.impl.louvain.Louvain;
import org.neo4j.graphalgo.results.LouvainResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class LouvainProc {
    public static final String CONFIG_CLUSTER_PROPERTY = "writeProperty";
    public static final String DEFAULT_CLUSTER_PROPERTY = "community";
    public static final int DEFAULT_ITERATIONS = 10;
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.louvain", mode=Mode.WRITE)
    @Description(value="CALL algo.louvain(label:String, relationship:String, {weightProperty:'weight', defaultValue:1.0, write: true, writeProperty:'community', concurrency:4}) YIELD nodes, communityCount, iterations, loadMillis, computeMillis, writeMillis")
    public Stream<LouvainResult> louvain(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        HeavyGraph graph;
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config).overrideNodeLabelOrQuery(label).overrideRelationshipTypeOrQuery(relationship);
        LouvainResult.Builder builder = LouvainResult.builder();
        try (ProgressTimer timer = builder.timeLoad();){
            graph = this.load(configuration);
        }
        builder.withNodeCount(graph.nodeCount());
        Louvain louvain = (Louvain)((Louvain)new Louvain(graph, graph, graph, Pools.DEFAULT, configuration.getConcurrency()).withProgressLogger(ProgressLogger.wrap(this.log, "Louvain"))).withTerminationFlag(TerminationFlag.wrap(this.transaction));
        try (ProgressTimer timer = builder.timeEval();){
            louvain.compute(configuration.getIterations(10));
            builder.withIterations(louvain.getIterations()).withCommunityCount(louvain.getCommunityCount());
        }
        if (configuration.isWriteFlag()) {
            builder.timeWrite(() -> this.write(graph, louvain.getCommunityIds(), configuration));
        }
        return Stream.of(builder.build());
    }

    @Procedure(value="algo.louvain.stream")
    @Description(value="CALL algo.louvain.stream(label:String, relationship:String, {weightProperty:'propertyName', defaultValue:1.0, concurrency:4) YIELD nodeId, community - yields a setId to each node id")
    public Stream<Louvain.Result> louvainStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config).overrideNodeLabelOrQuery(label).overrideRelationshipTypeOrQuery(relationship);
        HeavyGraph graph = this.load(configuration);
        return ((Louvain)((Louvain)new Louvain(graph, graph, graph, Pools.DEFAULT, configuration.getConcurrency()).withProgressLogger(ProgressLogger.wrap(this.log, "Louvain"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute(configuration.getIterations(10)).resultStream();
    }

    private HeavyGraph load(ProcedureConfiguration config) {
        return (HeavyGraph)new GraphLoader(this.api, Pools.DEFAULT).withOptionalLabel(config.getNodeLabelOrQuery()).withOptionalRelationshipType(config.getRelationshipOrQuery()).withOptionalRelationshipWeightsFromProperty(config.getProperty(), config.getPropertyDefaultValue(1.0)).withDirection(Direction.BOTH).load(HeavyGraphFactory.class);
    }

    private void write(Graph graph, int[] communities, ProcedureConfiguration configuration) {
        this.log.debug("Writing results");
        Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), TerminationFlag.wrap(this.transaction)).build().write(configuration.get(CONFIG_CLUSTER_PROPERTY, DEFAULT_CLUSTER_PROPERTY), communities, IntArrayTranslator.INSTANCE);
    }
}

