/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.api.RelationshipConsumer;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.neo4jview.DirectIdMapping;
import org.neo4j.graphalgo.core.sources.BothRelationshipAdapter;
import org.neo4j.graphalgo.core.sources.BufferedWeightMap;
import org.neo4j.graphalgo.core.sources.LazyIdMapper;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.container.RelationshipContainer;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.MSTPrim;
import org.neo4j.graphalgo.results.MSTPrimResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class MSTPrimProc {
    public static final String CONFIG_WRITE_RELATIONSHIP = "writeProperty";
    public static final String CONFIG_WRITE_RELATIONSHIP_DEFAULT = "mst";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.mst", mode=Mode.WRITE)
    @Description(value="CALL algo.mst(node:Node, weightProperty:String, {nodeQuery:String, relationshipQuery:String, write:boolean, writeProperty:String stats:boolean}) YIELD loadMillis, computeMillis, writeMillis, weightSum, weightMin, weightMax, relationshipCount")
    public Stream<MSTPrimResult> mst(@Name(value="startNode") Node startNode, @Name(value="weightProperty") String weightProperty, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        RelationshipContainer relationshipContainer;
        BufferedWeightMap weightMap;
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        LazyIdMapper idMapper = (LazyIdMapper)((LazyIdMapper.LazyIdMapperImporter)((LazyIdMapper.LazyIdMapperImporter)((LazyIdMapper.LazyIdMapperImporter)LazyIdMapper.importer(this.api).withWeightsFromProperty(weightProperty, 1.0)).withOptionalLabel(configuration.getNodeLabelOrQuery())).withOptionalRelationshipType(configuration.getRelationshipOrQuery())).build();
        MSTPrimResult.Builder builder = MSTPrimResult.builder();
        int startNodeId = idMapper.toMappedNodeId(startNode.getId());
        try (ProgressTimer timer = builder.timeLoad();){
            weightMap = (BufferedWeightMap)((BufferedWeightMap.WeightImporter)((BufferedWeightMap.WeightImporter)((BufferedWeightMap.WeightImporter)BufferedWeightMap.importer(this.api).withIdMapping(idMapper).withAnyDirection(true).withWeightsFromProperty(weightProperty, 1.0)).withOptionalLabel(configuration.getNodeLabelOrQuery())).withOptionalRelationshipType(configuration.getRelationshipOrQuery())).build();
            relationshipContainer = (RelationshipContainer)((RelationshipContainer.RCImporter)((RelationshipContainer.RCImporter)RelationshipContainer.importer(this.api).withIdMapping(idMapper).withDirection(Direction.BOTH).withOptionalLabel(configuration.getNodeLabelOrQuery())).withOptionalRelationshipType(configuration.getRelationshipOrQuery())).build();
        }
        MSTPrim mstPrim = (MSTPrim)((MSTPrim)new MSTPrim(idMapper, new BothRelationshipAdapter(relationshipContainer), weightMap).withProgressLogger(ProgressLogger.wrap(this.log, "MST(Prim)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction));
        builder.timeEval(() -> {
            mstPrim.compute(startNodeId);
            if (configuration.isStatsFlag()) {
                MSTPrim.MinimumSpanningTree.Aggregator aggregator = mstPrim.getMinimumSpanningTree().aggregate();
                builder.withWeightMax(aggregator.getMax()).withWeightMin(aggregator.getMin()).withWeightSum(aggregator.getSum()).withRelationshipCount(aggregator.getCount());
            }
        });
        if (configuration.isWriteFlag()) {
            MSTPrim.MinimumSpanningTree minimumSpanningTree = mstPrim.getMinimumSpanningTree();
            mstPrim.release();
            weightMap = null;
            relationshipContainer = null;
            builder.timeWrite(() -> Exporter.of(new DirectIdMapping(1L), this.api).withLog(this.log).build().writeRelationships(configuration.get(CONFIG_WRITE_RELATIONSHIP, CONFIG_WRITE_RELATIONSHIP_DEFAULT), (ops, typeId) -> minimumSpanningTree.forEachBFS(MSTPrimProc.writeBack((int)typeId, idMapper, ops))));
        }
        return Stream.of(builder.build());
    }

    private static RelationshipConsumer writeBack(int typeId, IdMapping mapping, DataWriteOperations ops) {
        return (source, target, rid) -> {
            try {
                ops.relationshipCreate(typeId, mapping.toOriginalNodeId(source), mapping.toOriginalNodeId(target));
            }
            catch (KernelException e) {
                throw Exceptions.launderedException((Throwable)e);
            }
            return true;
        };
    }
}

