/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.GraphFactory;
import org.neo4j.graphalgo.api.HugeGraph;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.paged.AllocationTracker;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.Algorithm;
import org.neo4j.graphalgo.impl.PageRankAlgorithm;
import org.neo4j.graphalgo.impl.PageRankResult;
import org.neo4j.graphalgo.results.PageRankScore;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public final class PageRankProc {
    public static final String CONFIG_DAMPING = "dampingFactor";
    public static final Double DEFAULT_DAMPING = 0.85;
    public static final Integer DEFAULT_ITERATIONS = 20;
    public static final String DEFAULT_SCORE_PROPERTY = "pagerank";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.pageRank", mode=Mode.WRITE)
    @Description(value="CALL algo.pageRank(label:String, relationship:String, {iterations:5, dampingFactor:0.85, write: true, writeProperty:'pagerank', concurrency:4}) YIELD nodes, iterations, loadMillis, computeMillis, writeMillis, dampingFactor, write, writeProperty - calculates page rank and potentially writes back")
    public Stream<PageRankScore.Stats> pageRank(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        PageRankScore.Stats.Builder statsBuilder = new PageRankScore.Stats.Builder();
        AllocationTracker tracker = AllocationTracker.create();
        Graph graph = this.load(label, relationship, tracker, configuration.getGraphImpl(), statsBuilder);
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        PageRankResult scores = this.evaluate(graph, tracker, terminationFlag, configuration, statsBuilder);
        this.log.info("PageRank: overall memory usage: %s", new Object[]{tracker.getUsageString()});
        this.write(graph, terminationFlag, scores, configuration, statsBuilder);
        return Stream.of(statsBuilder.build());
    }

    @Procedure(value="algo.pageRank.stream", mode=Mode.READ)
    @Description(value="CALL algo.pageRank.stream(label:String, relationship:String, {iterations:20, dampingFactor:0.85, concurrency:4}) YIELD node, score - calculates page rank and streams results")
    public Stream<PageRankScore> pageRankStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        PageRankScore.Stats.Builder statsBuilder = new PageRankScore.Stats.Builder();
        AllocationTracker tracker = AllocationTracker.create();
        Graph graph = this.load(label, relationship, tracker, configuration.getGraphImpl(), statsBuilder);
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        PageRankResult scores = this.evaluate(graph, tracker, terminationFlag, configuration, statsBuilder);
        this.log.info("PageRank: overall memory usage: %s", new Object[]{tracker.getUsageString()});
        if (graph instanceof HugeGraph) {
            HugeGraph hugeGraph = (HugeGraph)graph;
            return LongStream.range(0L, hugeGraph.nodeCount()).mapToObj(i -> new PageRankScore(this.api.getNodeById(hugeGraph.toOriginalNodeId(i)), scores.score(i)));
        }
        return IntStream.range(0, Math.toIntExact(graph.nodeCount())).mapToObj(i -> new PageRankScore(this.api.getNodeById(graph.toOriginalNodeId(i)), scores.score(i)));
    }

    private Graph load(String label, String relationship, AllocationTracker tracker, Class<? extends GraphFactory> graphFactory, PageRankScore.Stats.Builder statsBuilder) {
        GraphLoader graphLoader = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withAllocationTracker(tracker).withOptionalLabel(label).withOptionalRelationshipType(relationship).withDirection(Direction.OUTGOING).withoutRelationshipWeights();
        try (ProgressTimer timer = statsBuilder.timeLoad();){
            Graph graph = graphLoader.load(graphFactory);
            statsBuilder.withNodes(graph.nodeCount());
            Graph graph2 = graph;
            return graph2;
        }
    }

    private PageRankResult evaluate(Graph graph, AllocationTracker tracker, TerminationFlag terminationFlag, ProcedureConfiguration configuration, PageRankScore.Stats.Builder statsBuilder) {
        double dampingFactor = configuration.get(CONFIG_DAMPING, DEFAULT_DAMPING);
        int iterations = configuration.getIterations(DEFAULT_ITERATIONS);
        int batchSize = configuration.getBatchSize();
        int concurrency = configuration.getConcurrency(Pools.getNoThreadsInDefaultPool());
        this.log.debug("Computing page rank with damping of " + dampingFactor + " and " + iterations + " iterations.");
        PageRankAlgorithm prAlgo = PageRankAlgorithm.of(tracker, graph, dampingFactor, Pools.DEFAULT, concurrency, batchSize);
        Object algo = ((Algorithm)prAlgo.algorithm().withLog(this.log)).withTerminationFlag(terminationFlag);
        statsBuilder.timeEval(() -> prAlgo.compute(iterations));
        statsBuilder.withIterations(iterations).withDampingFactor(dampingFactor);
        PageRankResult pageRank = prAlgo.result();
        ((Algorithm)algo).release();
        graph.release();
        return pageRank;
    }

    private void write(Graph graph, TerminationFlag terminationFlag, PageRankResult result, ProcedureConfiguration configuration, PageRankScore.Stats.Builder statsBuilder) {
        if (configuration.isWriteFlag(true)) {
            this.log.debug("Writing results");
            String propertyName = configuration.getWriteProperty(DEFAULT_SCORE_PROPERTY);
            try (ProgressTimer timer = statsBuilder.timeWrite();){
                Exporter exporter = Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build();
                result.export(propertyName, exporter);
            }
            statsBuilder.withWrite(true).withProperty(propertyName);
        } else {
            statsBuilder.withWrite(false);
        }
    }
}

