/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import java.util.Map;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.DoubleArrayTranslator;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.ShortestPathDeltaStepping;
import org.neo4j.graphalgo.results.DeltaSteppingProcResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathDeltaSteppingProc {
    public static final String WRITE_PROPERTY = "writeProperty";
    public static final String DEFAULT_TARGET_PROPERTY = "sssp";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.shortestPath.deltaStepping.stream")
    @Description(value="CALL algo.shortestPath.deltaStepping.stream(startNode:Node, weightProperty:String, delta:Double{label:'labelName', relationship:'relationshipName', defaultValue:1.0, concurrency:4}) YIELD nodeId, distance - yields a stream of {nodeId, distance} from start to end (inclusive)")
    public Stream<ShortestPathDeltaStepping.DeltaSteppingResult> deltaSteppingStream(@Name(value="startNode") Node startNode, @Name(value="propertyName") String propertyName, @Name(value="delta") Double delta, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withRelationshipWeightsFromProperty(propertyName, configuration.getPropertyDefaultValue(Double.MAX_VALUE)).withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        ShortestPathDeltaStepping algo = ((ShortestPathDeltaStepping)((ShortestPathDeltaStepping)new ShortestPathDeltaStepping(graph, delta).withProgressLogger(ProgressLogger.wrap(this.log, "ShortestPaths(DeltaStepping)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).withExecutorService(Executors.newFixedThreadPool(configuration.getConcurrency())).compute(startNode.getId());
        graph.release();
        return algo.resultStream();
    }

    @Procedure(value="algo.shortestPath.deltaStepping", mode=Mode.WRITE)
    @Description(value="CALL algo.shortestPath.deltaStepping(startNode:Node, weightProperty:String, delta:Double{label:'labelName', relationship:'relationshipName', defaultValue:1.0, write:true, writeProperty:'sssp'}) YIELD loadDuration, evalDuration, writeDuration, nodeCount")
    public Stream<DeltaSteppingProcResult> deltaStepping(@Name(value="startNode") Node startNode, @Name(value="propertyName") String propertyName, @Name(value="delta") Double delta, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        Graph graph;
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        DeltaSteppingProcResult.Builder builder = DeltaSteppingProcResult.builder();
        try (ProgressTimer timer = builder.timeLoad();){
            graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withRelationshipWeightsFromProperty(propertyName, configuration.getPropertyDefaultValue(Double.MAX_VALUE)).withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        }
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        ShortestPathDeltaStepping algorithm = ((ShortestPathDeltaStepping)((ShortestPathDeltaStepping)new ShortestPathDeltaStepping(graph, delta).withProgressLogger(ProgressLogger.wrap(this.log, "ShortestPaths(DeltaStepping)"))).withTerminationFlag(terminationFlag)).withExecutorService(Pools.DEFAULT);
        builder.timeEval(() -> algorithm.compute(startNode.getId()));
        if (configuration.isWriteFlag()) {
            double[] shortestPaths = algorithm.getShortestPaths();
            algorithm.release();
            graph.release();
            builder.timeWrite(() -> Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build().write(configuration.get(WRITE_PROPERTY, DEFAULT_TARGET_PROPERTY), shortestPaths, DoubleArrayTranslator.INSTANCE));
        }
        return Stream.of(builder.withNodeCount(graph.nodeCount()).build());
    }
}

