/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import com.carrotsearch.hppc.IntArrayDeque;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.api.IdMapping;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.ShortestPathDijkstra;
import org.neo4j.graphalgo.results.DijkstraResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathProc {
    public static final String DEFAULT_TARGET_PROPERTY = "sssp";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.shortestPath.stream")
    @Description(value="CALL algo.shortestPath.stream(startNode:Node, endNode:Node, weightProperty:String{nodeQuery:'labelName', relationshipQuery:'relationshipName', direction:'BOTH', defaultValue:1.0}) YIELD nodeId, cost - yields a stream of {nodeId, cost} from start to end (inclusive)")
    public Stream<ShortestPathDijkstra.Result> dijkstraStream(@Name(value="startNode") Node startNode, @Name(value="endNode") Node endNode, @Name(value="propertyName") String propertyName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        Direction direction = configuration.getDirection(Direction.BOTH);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withOptionalRelationshipWeightsFromProperty(propertyName, configuration.getPropertyDefaultValue(1.0)).withDirection(direction).load(configuration.getGraphImpl());
        return ((ShortestPathDijkstra)((ShortestPathDijkstra)new ShortestPathDijkstra(graph).withProgressLogger(ProgressLogger.wrap(this.log, "ShortestPath(Dijkstra)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute(startNode.getId(), endNode.getId(), direction).resultStream();
    }

    @Procedure(value="algo.shortestPath", mode=Mode.WRITE)
    @Description(value="CALL algo.shortestPath(startNode:Node, endNode:Node, weightProperty:String{nodeQuery:'labelName', relationshipQuery:'relationshipName', direction:'BOTH', defaultValue:1.0, write:'true', writeProperty:'sssp'}) YIELD nodeId, cost, loadMillis, evalMillis, writeMillis - yields nodeCount, totalCost, loadMillis, evalMillis, writeMillis")
    public Stream<DijkstraResult> dijkstra(@Name(value="startNode") Node startNode, @Name(value="endNode") Node endNode, @Name(value="propertyName") String propertyName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ShortestPathDijkstra dijkstra;
        Graph graph;
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        DijkstraResult.Builder builder = DijkstraResult.builder();
        Direction direction = configuration.getDirection(Direction.BOTH);
        try (ProgressTimer timer = builder.timeLoad();){
            graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withOptionalRelationshipWeightsFromProperty(propertyName, configuration.getPropertyDefaultValue(1.0)).withDirection(direction).load(configuration.getGraphImpl());
        }
        timer = builder.timeEval();
        var11_9 = null;
        try {
            dijkstra = ((ShortestPathDijkstra)((ShortestPathDijkstra)new ShortestPathDijkstra(graph).withProgressLogger(ProgressLogger.wrap(this.log, "ShortestPath(Dijkstra)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute(startNode.getId(), endNode.getId(), direction);
            builder.withNodeCount(dijkstra.getPathLength()).withTotalCosts(dijkstra.getTotalCost());
        }
        catch (Throwable throwable) {
            var11_9 = throwable;
            throw throwable;
        }
        finally {
            if (timer != null) {
                if (var11_9 != null) {
                    try {
                        timer.close();
                    }
                    catch (Throwable throwable) {
                        var11_9.addSuppressed(throwable);
                    }
                } else {
                    timer.close();
                }
            }
        }
        if (configuration.isWriteFlag()) {
            timer = builder.timeWrite();
            var11_9 = null;
            try {
                IntArrayDeque finalPath = dijkstra.getFinalPath();
                dijkstra.release();
                DequeMapping mapping = new DequeMapping(graph, finalPath);
                Exporter.of(mapping, this.api).withLog(this.log).build().write(configuration.getWriteProperty(DEFAULT_TARGET_PROPERTY), finalPath, (data, nodeId) -> (int)nodeId);
            }
            catch (Throwable throwable) {
                var11_9 = throwable;
                throw throwable;
            }
            finally {
                if (timer != null) {
                    if (var11_9 != null) {
                        try {
                            timer.close();
                        }
                        catch (Throwable throwable) {
                            var11_9.addSuppressed(throwable);
                        }
                    } else {
                        timer.close();
                    }
                }
            }
        }
        return Stream.of(builder.build());
    }

    private static final class DequeMapping
    implements IdMapping {
        private final IdMapping mapping;
        private final int[] data;
        private final int offset;
        private final int length;

        private DequeMapping(IdMapping mapping, IntArrayDeque data) {
            this.mapping = mapping;
            if (data.head <= data.tail) {
                this.data = data.buffer;
                this.offset = data.head;
                this.length = data.tail - data.head;
            } else {
                this.data = data.toArray();
                this.offset = 0;
                this.length = this.data.length;
            }
        }

        @Override
        public int toMappedNodeId(long nodeId) {
            return this.mapping.toMappedNodeId(nodeId);
        }

        @Override
        public long toOriginalNodeId(int nodeId) {
            assert (nodeId < this.length);
            return this.mapping.toOriginalNodeId(this.data[this.offset + nodeId]);
        }

        @Override
        public boolean contains(long nodeId) {
            return true;
        }

        @Override
        public long nodeCount() {
            return this.length;
        }
    }
}

