/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import com.carrotsearch.hppc.IntDoubleMap;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.core.write.IntDoubleMapTranslator;
import org.neo4j.graphalgo.impl.ShortestPaths;
import org.neo4j.graphalgo.results.ShortestPathResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ShortestPathsProc {
    public static final String WRITE_PROPERTY = "writeProperty";
    public static final String DEFAULT_TARGET_PROPERTY = "sssp";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.shortestPaths.stream")
    @Description(value="CALL algo.shortestPaths.stream(startNode:Node, weightProperty:String{nodeQuery:'labelName', relationshipQuery:'relationshipName', defaultValue:1.0}) YIELD nodeId, distance - yields a stream of {nodeId, cost} from start to end (inclusive)")
    public Stream<ShortestPaths.Result> dijkstraStream(@Name(value="startNode") Node startNode, @Name(value="propertyName") String propertyName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withOptionalRelationshipWeightsFromProperty(propertyName, configuration.getPropertyDefaultValue(1.0)).withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        ShortestPaths algo = ((ShortestPaths)((ShortestPaths)new ShortestPaths(graph).withProgressLogger(ProgressLogger.wrap(this.log, "ShortestPaths"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute(startNode.getId());
        graph.release();
        return algo.resultStream();
    }

    @Procedure(value="algo.shortestPaths", mode=Mode.WRITE)
    @Description(value="CALL algo.shortestPaths(startNode:Node, weightProperty:String{write:true, targetProperty:'path', nodeQuery:'labelName', relationshipQuery:'relationshipName', defaultValue:1.0}) YIELD loadDuration, evalDuration, writeDuration, nodeCount, targetProperty - yields nodeCount, totalCost, loadDuration, evalDuration")
    public Stream<ShortestPathResult> dijkstra(@Name(value="startNode") Node startNode, @Name(value="propertyName") String propertyName, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        ShortestPathResult.Builder builder = ShortestPathResult.builder();
        ProgressTimer load = builder.timeLoad();
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withOptionalRelationshipWeightsFromProperty(propertyName, configuration.getPropertyDefaultValue(1.0)).withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        load.stop();
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        ShortestPaths algorithm = (ShortestPaths)((ShortestPaths)new ShortestPaths(graph).withProgressLogger(ProgressLogger.wrap(this.log, "ShortestPaths"))).withTerminationFlag(terminationFlag);
        builder.timeEval(() -> algorithm.compute(startNode.getId()));
        if (configuration.isWriteFlag()) {
            builder.timeWrite(() -> {
                IntDoubleMap shortestPaths = algorithm.getShortestPaths();
                algorithm.release();
                graph.release();
                Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build().write(configuration.getWriteProperty(DEFAULT_TARGET_PROPERTY), shortestPaths, IntDoubleMapTranslator.INSTANCE);
            });
        }
        return Stream.of(builder.build());
    }
}

