/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.ObjectArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.neo4jview.DirectIdMapping;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.core.write.OptionalIntArrayTranslator;
import org.neo4j.graphalgo.impl.ForwardBackwardScc;
import org.neo4j.graphalgo.impl.SCCIterativeTarjan;
import org.neo4j.graphalgo.impl.SCCTarjan;
import org.neo4j.graphalgo.impl.SCCTunedTarjan;
import org.neo4j.graphalgo.impl.multistepscc.MultistepSCC;
import org.neo4j.graphalgo.results.SCCResult;
import org.neo4j.graphalgo.results.SCCStreamResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class StronglyConnectedComponentsProc {
    public static final String CONFIG_WRITE_PROPERTY = "partitionProperty";
    public static final String CONFIG_CLUSTER = "partition";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.scc", mode=Mode.WRITE)
    @Description(value="CALL algo.scc(label:String, relationship:String, config:Map<String, Object>) YIELD loadMillis, computeMillis, writeMillis, setCount, maxSetSize, minSetSize")
    public Stream<SCCResult> sccDefaultMethod(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.sccIterativeTarjan(label, relationship, config);
    }

    @Procedure(value="algo.scc.stream")
    @Description(value="CALL algo.scc.stream(label:String, relationship:String, config:Map<String, Object>) YIELD loadMillis, computeMillis, writeMillis, setCount, maxSetSize, minSetSize")
    public Stream<SCCStreamResult> sccDefaultMethodStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.sccIterativeTarjanStream(label, relationship, config);
    }

    @Procedure(value="algo.scc.recursive.tarjan", mode=Mode.WRITE)
    @Description(value="CALL algo.scc.tarjan(label:String, relationship:String, config:Map<String, Object>) YIELD loadMillis, computeMillis, writeMillis, setCount, maxSetSize, minSetSize")
    public Stream<SCCResult> sccTarjan(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        SCCResult.Builder builder = SCCResult.builder();
        ProgressTimer loadTimer = builder.timeLoad();
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutRelationshipWeights().withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        loadTimer.stop();
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        SCCTarjan tarjan = (SCCTarjan)((SCCTarjan)new SCCTarjan(graph).withProgressLogger(ProgressLogger.wrap(this.log, "SCC(Tarjan)"))).withTerminationFlag(terminationFlag);
        builder.timeEval(() -> {
            tarjan.compute();
            builder.withMaxSetSize(tarjan.getMaxSetSize()).withMinSetSize(tarjan.getMinSetSize()).withSetCount(tarjan.getConnectedComponents().size());
        });
        if (configuration.isWriteFlag()) {
            builder.timeWrite(() -> {
                ObjectArrayList<IntSet> connectedComponents = tarjan.getConnectedComponents();
                tarjan.release();
                Exporter.of(new DirectIdMapping(connectedComponents.size()), this.api).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build().write(configuration.get(CONFIG_WRITE_PROPERTY, CONFIG_CLUSTER), propertyId -> (ops, id) -> {
                    int setId = (int)id;
                    DefinedProperty property = DefinedProperty.intProperty((int)propertyId, (int)(setId + 1));
                    for (IntCursor iCursor : (IntSet)connectedComponents.get(setId)) {
                        ops.nodeSetProperty(graph.toOriginalNodeId(iCursor.value), property);
                    }
                });
            });
        }
        return Stream.of(builder.build());
    }

    @Procedure(value="algo.scc.recursive.tunedTarjan", mode=Mode.WRITE)
    @Description(value="CALL algo.scc.recursive.tunedTarjan(label:String, relationship:String, config:Map<String, Object>) YIELD loadMillis, computeMillis, writeMillis, setCount, maxSetSize, minSetSize")
    public Stream<SCCResult> sccTunedTarjan(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        SCCResult.Builder builder = SCCResult.builder();
        ProgressTimer loadTimer = builder.timeLoad();
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutRelationshipWeights().withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        loadTimer.stop();
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        SCCTunedTarjan tarjan = (SCCTunedTarjan)((SCCTunedTarjan)new SCCTunedTarjan(graph).withProgressLogger(ProgressLogger.wrap(this.log, "SCC(TunedTarjan)"))).withTerminationFlag(terminationFlag);
        builder.timeEval(tarjan::compute);
        builder.withMaxSetSize(tarjan.getMaxSetSize()).withMinSetSize(tarjan.getMinSetSize()).withSetCount(tarjan.getSetCount());
        if (configuration.isWriteFlag()) {
            builder.timeWrite(() -> Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build().write(configuration.get(CONFIG_WRITE_PROPERTY, CONFIG_CLUSTER), tarjan.getConnectedComponents(), OptionalIntArrayTranslator.INSTANCE));
        }
        return Stream.of(builder.build());
    }

    @Procedure(value="algo.scc.recursive.tunedTarjan.stream", mode=Mode.WRITE)
    @Description(value="CALL algo.scc.recursive.tunedTarjan.stream(label:String, relationship:String, config:Map<String, Object>) YIELD nodeId, partition")
    public Stream<SCCStreamResult> sccTunedTarjanStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutRelationshipWeights().withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        return ((SCCTunedTarjan)((SCCTunedTarjan)new SCCTunedTarjan(graph).withProgressLogger(ProgressLogger.wrap(this.log, "SCC(TunedTarjan)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute().resultStream();
    }

    @Procedure(value="algo.scc.iterative", mode=Mode.WRITE)
    @Description(value="CALL algo.scc.iterative(label:String, relationship:String, config:Map<String, Object>) YIELD loadMillis, computeMillis, writeMillis, setCount, maxSetSize, minSetSize")
    public Stream<SCCResult> sccIterativeTarjan(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        SCCResult.Builder builder = SCCResult.builder();
        ProgressTimer loadTimer = builder.timeLoad();
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutRelationshipWeights().withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        loadTimer.stop();
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        SCCIterativeTarjan tarjan = (SCCIterativeTarjan)((SCCIterativeTarjan)new SCCIterativeTarjan(graph).withProgressLogger(ProgressLogger.wrap(this.log, "SCC(IterativeTarjan)"))).withTerminationFlag(terminationFlag);
        builder.timeEval(tarjan::compute);
        builder.withSetCount(tarjan.getSetCount()).withMinSetSize(tarjan.getMinSetSize()).withMaxSetSize(tarjan.getMaxSetSize());
        if (configuration.isWriteFlag()) {
            int[] connectedComponents = tarjan.getConnectedComponents();
            graph.release();
            tarjan.release();
            builder.timeWrite(() -> Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build().write(configuration.get(CONFIG_WRITE_PROPERTY, CONFIG_CLUSTER), connectedComponents, OptionalIntArrayTranslator.INSTANCE));
        }
        return Stream.of(builder.build());
    }

    @Procedure(value="algo.scc.iterative.stream", mode=Mode.WRITE)
    @Description(value="CALL algo.scc.iterative.stream(label:String, relationship:String, config:Map<String, Object>) YIELD nodeId, partition")
    public Stream<SCCStreamResult> sccIterativeTarjanStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutRelationshipWeights().withDirection(Direction.OUTGOING).load(configuration.getGraphImpl());
        SCCIterativeTarjan compute = ((SCCIterativeTarjan)((SCCIterativeTarjan)new SCCIterativeTarjan(graph).withProgressLogger(ProgressLogger.wrap(this.log, "SCC(IterativeTarjan)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute();
        graph.release();
        return compute.resultStream();
    }

    @Procedure(value="algo.scc.multistep", mode=Mode.WRITE)
    @Description(value="CALL algo.scc.multistep(label:String, relationship:String, {write:true, concurrency:4, cutoff:100000}) YIELD loadMillis, computeMillis, writeMillis, setCount, maxSetSize, minSetSize")
    public Stream<SCCResult> multistep(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        SCCResult.Builder builder = SCCResult.builder();
        ProgressTimer loadTimer = builder.timeLoad();
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutRelationshipWeights().load(configuration.getGraphImpl());
        loadTimer.stop();
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        MultistepSCC multistep = (MultistepSCC)((MultistepSCC)new MultistepSCC(graph, Pools.DEFAULT, configuration.getConcurrency(), configuration.getNumber("cutoff", 100000).intValue()).withProgressLogger(ProgressLogger.wrap(this.log, "SCC(MultiStep)"))).withTerminationFlag(terminationFlag);
        builder.timeEval(multistep::compute);
        builder.withMaxSetSize(multistep.getMaxSetSize()).withMinSetSize(multistep.getMinSetSize()).withSetCount(multistep.getSetCount());
        if (configuration.isWriteFlag()) {
            int[] connectedComponents = multistep.getConnectedComponents();
            graph.release();
            multistep.release();
            builder.timeWrite(() -> Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build().write(configuration.get(CONFIG_WRITE_PROPERTY, CONFIG_CLUSTER), connectedComponents, OptionalIntArrayTranslator.INSTANCE));
        }
        return Stream.of(builder.build());
    }

    @Procedure(value="algo.scc.multistep.stream")
    @Description(value="CALL algo.scc.multistep.stream(label:String, relationship:String, {write:true, concurrency:4, cutoff:100000}) YIELD nodeId, partition")
    public Stream<SCCStreamResult> multistepStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutRelationshipWeights().load(configuration.getGraphImpl());
        MultistepSCC multistep = (MultistepSCC)((MultistepSCC)new MultistepSCC(graph, Pools.DEFAULT, configuration.getConcurrency(), configuration.getNumber("cutoff", 100000).intValue()).withProgressLogger(ProgressLogger.wrap(this.log, "SCC(MultiStep)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction));
        multistep.compute();
        graph.release();
        return multistep.resultStream();
    }

    @Procedure(value="algo.scc.forwardBackward.stream")
    @Description(value="CALL algo.scc.forwardBackward.stream(long startNodeId, label:String, relationship:String, {write:true, concurrency:4}) YIELD nodeId, partition")
    public Stream<ForwardBackwardScc.Result> fwbwStream(@Name(value="startNodeId", defaultValue="0") long startNodeId, @Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(label).withOptionalRelationshipType(relationship).withoutRelationshipWeights().load(configuration.getGraphImpl());
        ForwardBackwardScc algo = ((ForwardBackwardScc)((ForwardBackwardScc)new ForwardBackwardScc(graph, Pools.DEFAULT, configuration.getConcurrency()).withProgressLogger(ProgressLogger.wrap(this.log, "SCC(ForwardBackward)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute(graph.toMappedNodeId(startNodeId));
        graph.release();
        return algo.resultStream();
    }
}

