/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.write.AtomicIntArrayTranslator;
import org.neo4j.graphalgo.core.write.DoubleArrayTranslator;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.TriangleCount;
import org.neo4j.graphalgo.impl.TriangleCountExp;
import org.neo4j.graphalgo.impl.TriangleStream;
import org.neo4j.graphalgo.results.AbstractResultBuilder;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TriangleProc {
    public static final String DEFAULT_WRITE_PROPERTY_VALUE = "triangles";
    public static final String COEFFICIENT_WRITE_PROPERTY_VALUE = "clusteringCoefficientProperty";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.triangle.stream")
    @Description(value="CALL algo.triangle.stream(label, relationship, {concurrency:4}) YIELD nodeA, nodeB, nodeC - yield nodeA, nodeB and nodeC which form a triangle")
    public Stream<TriangleStream.Result> triangleStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config).overrideNodeLabelOrQuery(label).overrideRelationshipTypeOrQuery(relationship);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withoutRelationshipWeights().withoutNodeWeights().withLog(this.log).withDirection(TriangleCount.D).load(configuration.getGraphImpl());
        TriangleStream triangleStream = (TriangleStream)((TriangleStream)new TriangleStream(graph, Pools.DEFAULT, configuration.getConcurrency()).withProgressLogger(ProgressLogger.wrap(this.log, "triangleStream"))).withTerminationFlag(TerminationFlag.wrap(this.transaction));
        return triangleStream.resultStream();
    }

    @Procedure(value="algo.triangleCount.exp1.stream")
    @Description(value="CALL algo.triangleCount.exp1.stream(label, relationship, {concurrency:4}) YIELD nodeId, triangles - yield nodeId, number of triangles")
    public Stream<TriangleCount.Result> triangleCountStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config).overrideNodeLabelOrQuery(label).overrideRelationshipTypeOrQuery(relationship);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withoutRelationshipWeights().withoutNodeWeights().withLog(this.log).withDirection(TriangleCount.D).load(configuration.getGraphImpl());
        TriangleCount triangleCount = ((TriangleCount)((TriangleCount)new TriangleCount(graph, Pools.DEFAULT, configuration.getConcurrency()).withProgressLogger(ProgressLogger.wrap(this.log, "triangleCount"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute();
        return triangleCount.resultStream();
    }

    @Procedure(value="algo.triangleCount.stream")
    @Description(value="CALL algo.triangleCount.stream(label, relationship, {concurrency:8}) YIELD nodeId, triangles - yield nodeId, number of triangles")
    public Stream<TriangleCountExp.Result> triangleCountExp1Stream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config).overrideNodeLabelOrQuery(label).overrideRelationshipTypeOrQuery(relationship);
        Graph graph = new GraphLoader(this.api, Pools.DEFAULT).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withoutRelationshipWeights().withoutNodeWeights().withLog(this.log).withDirection(TriangleCount.D).load(configuration.getGraphImpl());
        TriangleCountExp triangleCount = ((TriangleCountExp)((TriangleCountExp)new TriangleCountExp(graph, Pools.DEFAULT, configuration.getConcurrency()).withProgressLogger(ProgressLogger.wrap(this.log, "triangleCount"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute();
        return triangleCount.resultStream();
    }

    @Procedure(value="algo.triangleCount.exp1", mode=Mode.WRITE)
    @Description(value="CALL algo.triangleCount.exp1(label, relationship, {concurrency:4, write:true, writeProperty:'triangles', clusteringCoefficientProperty:'coefficient'}) YIELD loadMillis, computeMillis, writeMillis, nodeCount, triangleCount, averageClusteringCoefficient")
    public Stream<Result> triangleCount(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        double[] clusteringCoefficients;
        TriangleCount triangleCount;
        Graph graph;
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config).overrideNodeLabelOrQuery(label).overrideRelationshipTypeOrQuery(relationship);
        TriangleCountResultBuilder builder = new TriangleCountResultBuilder();
        try (ProgressTimer timer = builder.timeLoad();){
            graph = new GraphLoader(this.api, Pools.DEFAULT).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withoutRelationshipWeights().withoutNodeWeights().withLog(this.log).withDirection(TriangleCount.D).load(configuration.getGraphImpl());
        }
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        try (ProgressTimer timer = builder.timeEval();){
            triangleCount = ((TriangleCount)((TriangleCount)new TriangleCount(graph, Pools.DEFAULT, configuration.getConcurrency()).withProgressLogger(ProgressLogger.wrap(this.log, "triangleCount"))).withTerminationFlag(terminationFlag)).compute();
            clusteringCoefficients = triangleCount.getClusteringCoefficients();
        }
        if (configuration.isWriteFlag()) {
            timer = builder.timeWrite();
            var11_11 = null;
            try {
                Optional<String> coefficientProperty = configuration.getString(COEFFICIENT_WRITE_PROPERTY_VALUE);
                Exporter exporter = Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build();
                if (coefficientProperty.isPresent()) {
                    exporter.write(configuration.getWriteProperty(DEFAULT_WRITE_PROPERTY_VALUE), triangleCount.getTriangles(), AtomicIntArrayTranslator.INSTANCE, coefficientProperty.get(), clusteringCoefficients, DoubleArrayTranslator.INSTANCE);
                } else {
                    exporter.write(configuration.getWriteProperty(DEFAULT_WRITE_PROPERTY_VALUE), triangleCount.getTriangles(), AtomicIntArrayTranslator.INSTANCE);
                }
            }
            catch (Throwable throwable) {
                var11_11 = throwable;
                throw throwable;
            }
            finally {
                if (timer != null) {
                    if (var11_11 != null) {
                        try {
                            timer.close();
                        }
                        catch (Throwable throwable) {
                            var11_11.addSuppressed(throwable);
                        }
                    } else {
                        timer.close();
                    }
                }
            }
        }
        builder.withNodeCount(graph.nodeCount()).withTriangleCount(triangleCount.getTriangleCount()).withAverageClusteringCoefficient(triangleCount.getAverageClusteringCoefficient());
        return Stream.of(builder.build());
    }

    @Procedure(value="algo.triangleCount", mode=Mode.WRITE)
    @Description(value="CALL algo.triangleCount(label, relationship, {concurrency:8, write:true, writeProperty:'triangles', clusteringCoefficientProperty:'coefficient'}) YIELD loadMillis, computeMillis, writeMillis, nodeCount, triangleCount, averageClusteringCoefficient")
    public Stream<Result> triangleCountExp1(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        double[] clusteringCoefficients;
        TriangleCountExp triangleCount;
        Graph graph;
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config).overrideNodeLabelOrQuery(label).overrideRelationshipTypeOrQuery(relationship);
        TriangleCountResultBuilder builder = new TriangleCountResultBuilder();
        try (ProgressTimer timer = builder.timeLoad();){
            graph = new GraphLoader(this.api, Pools.DEFAULT).withOptionalLabel(configuration.getNodeLabelOrQuery()).withOptionalRelationshipType(configuration.getRelationshipOrQuery()).withoutRelationshipWeights().withoutNodeWeights().withLog(this.log).withDirection(TriangleCount.D).load(configuration.getGraphImpl());
        }
        TerminationFlag terminationFlag = TerminationFlag.wrap(this.transaction);
        try (ProgressTimer timer = builder.timeEval();){
            triangleCount = ((TriangleCountExp)((TriangleCountExp)new TriangleCountExp(graph, Pools.DEFAULT, configuration.getConcurrency()).withProgressLogger(ProgressLogger.wrap(this.log, "triangleCount"))).withTerminationFlag(terminationFlag)).compute();
            clusteringCoefficients = triangleCount.getClusteringCoefficients();
        }
        if (configuration.isWriteFlag()) {
            timer = builder.timeWrite();
            var11_11 = null;
            try {
                Optional<String> coefficientProperty = configuration.getString(COEFFICIENT_WRITE_PROPERTY_VALUE);
                Exporter exporter = Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), terminationFlag).build();
                if (coefficientProperty.isPresent()) {
                    exporter.write(configuration.getWriteProperty(DEFAULT_WRITE_PROPERTY_VALUE), triangleCount.getTriangles(), AtomicIntArrayTranslator.INSTANCE, coefficientProperty.get(), clusteringCoefficients, DoubleArrayTranslator.INSTANCE);
                } else {
                    exporter.write(configuration.getWriteProperty(DEFAULT_WRITE_PROPERTY_VALUE), triangleCount.getTriangles(), AtomicIntArrayTranslator.INSTANCE);
                }
            }
            catch (Throwable throwable) {
                var11_11 = throwable;
                throw throwable;
            }
            finally {
                if (timer != null) {
                    if (var11_11 != null) {
                        try {
                            timer.close();
                        }
                        catch (Throwable throwable) {
                            var11_11.addSuppressed(throwable);
                        }
                    } else {
                        timer.close();
                    }
                }
            }
        }
        builder.withNodeCount(graph.nodeCount()).withTriangleCount(triangleCount.getTriangleCount()).withAverageClusteringCoefficient(triangleCount.getAverageClusteringCoefficient());
        return Stream.of(builder.build());
    }

    public class TriangleCountResultBuilder
    extends AbstractResultBuilder<Result> {
        private long nodeCount = -1L;
        private long triangleCount = -1L;
        private double averageClusteringCoefficient = -1.0;

        public TriangleCountResultBuilder withAverageClusteringCoefficient(double averageClusteringCoefficient) {
            this.averageClusteringCoefficient = averageClusteringCoefficient;
            return this;
        }

        public TriangleCountResultBuilder withNodeCount(long nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public TriangleCountResultBuilder withTriangleCount(long triangleCount) {
            this.triangleCount = triangleCount;
            return this;
        }

        @Override
        public Result build() {
            return new Result(this.loadDuration, this.evalDuration, this.writeDuration, this.nodeCount, this.triangleCount, this.averageClusteringCoefficient);
        }
    }

    public static class Result {
        public final long loadMillis;
        public final long computeMillis;
        public final long writeMillis;
        public final long nodeCount;
        public final long triangleCount;
        public final double averageClusteringCoefficient;

        public Result(long loadMillis, long computeMillis, long writeMillis, long nodeCount, long triangleCount, double averageClusteringCoefficient) {
            this.loadMillis = loadMillis;
            this.computeMillis = computeMillis;
            this.writeMillis = writeMillis;
            this.nodeCount = nodeCount;
            this.triangleCount = triangleCount;
            this.averageClusteringCoefficient = averageClusteringCoefficient;
        }
    }
}

