/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphalgo.api.Graph;
import org.neo4j.graphalgo.core.GraphLoader;
import org.neo4j.graphalgo.core.ProcedureConfiguration;
import org.neo4j.graphalgo.core.utils.Pools;
import org.neo4j.graphalgo.core.utils.ProgressLogger;
import org.neo4j.graphalgo.core.utils.ProgressTimer;
import org.neo4j.graphalgo.core.utils.TerminationFlag;
import org.neo4j.graphalgo.core.utils.dss.DisjointSetStruct;
import org.neo4j.graphalgo.core.write.DisjointSetStructTranslator;
import org.neo4j.graphalgo.core.write.Exporter;
import org.neo4j.graphalgo.impl.GraphUnionFind;
import org.neo4j.graphalgo.results.UnionFindResult;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class UnionFindProc {
    public static final String CONFIG_THRESHOLD = "threshold";
    public static final String CONFIG_CLUSTER_PROPERTY = "partitionProperty";
    public static final String DEFAULT_CLUSTER_PROPERTY = "partition";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public Log log;
    @Context
    public KernelTransaction transaction;

    @Procedure(value="algo.unionFind", mode=Mode.WRITE)
    @Description(value="CALL algo.unionFind(label:String, relationship:String, {weightProperty:'weight', threshold:0.42, defaultValue:1.0, write: true, partitionProperty:'partition'}) YIELD nodes, setCount, loadMillis, computeMillis, writeMillis")
    public Stream<UnionFindResult> unionFind(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        DisjointSetStruct struct;
        Graph graph;
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config).overrideNodeLabelOrQuery(label).overrideRelationshipTypeOrQuery(relationship);
        UnionFindResult.Builder builder = UnionFindResult.builder();
        try (ProgressTimer timer = builder.timeLoad();){
            graph = this.load(configuration);
        }
        try (ProgressTimer timer = builder.timeEval();){
            struct = this.evaluate(graph, configuration);
        }
        if (configuration.isWriteFlag()) {
            builder.timeWrite(() -> this.write(graph, struct, configuration));
        }
        return Stream.of(builder.withNodeCount(graph.nodeCount()).withSetCount(struct.getSetCount()).build());
    }

    @Procedure(value="algo.unionFind.stream")
    @Description(value="CALL algo.unionFind.stream(label:String, relationship:String, {weightProperty:'propertyName', threshold:0.42, defaultValue:1.0) YIELD nodeId, setId - yields a setId to each node id")
    public Stream<DisjointSetStruct.Result> unionFindStream(@Name(value="label", defaultValue="") String label, @Name(value="relationship", defaultValue="") String relationship, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        ProcedureConfiguration configuration = ProcedureConfiguration.create(config).overrideNodeLabelOrQuery(label).overrideRelationshipTypeOrQuery(relationship);
        Graph graph = this.load(configuration);
        return this.evaluate(graph, configuration).resultStream(graph);
    }

    private Graph load(ProcedureConfiguration config) {
        return new GraphLoader(this.api, Pools.DEFAULT).withLog(this.log).withOptionalLabel(config.getNodeLabelOrQuery()).withOptionalRelationshipType(config.getRelationshipOrQuery()).withOptionalRelationshipWeightsFromProperty(config.getProperty(), config.getPropertyDefaultValue(1.0)).withDirection(Direction.OUTGOING).load(config.getGraphImpl());
    }

    private DisjointSetStruct evaluate(Graph graph, ProcedureConfiguration config) {
        DisjointSetStruct struct;
        GraphUnionFind graphUnionFind = new GraphUnionFind(graph);
        if (config.containsKeys("weightProperty", CONFIG_THRESHOLD)) {
            Double threshold = config.get(CONFIG_THRESHOLD, 0.0);
            this.log.debug("Computing union find with threshold " + threshold);
            struct = ((GraphUnionFind)((GraphUnionFind)graphUnionFind.withProgressLogger(ProgressLogger.wrap(this.log, "CC(SequentialUnionFind)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute(threshold);
        } else {
            this.log.debug("Computing union find without threshold");
            struct = ((GraphUnionFind)((GraphUnionFind)graphUnionFind.withProgressLogger(ProgressLogger.wrap(this.log, "CC(SequentialUnionFind)"))).withTerminationFlag(TerminationFlag.wrap(this.transaction))).compute();
        }
        graphUnionFind.release();
        graph.release();
        return struct;
    }

    private void write(Graph graph, DisjointSetStruct struct, ProcedureConfiguration configuration) {
        this.log.debug("Writing results");
        Exporter.of(this.api, graph).withLog(this.log).parallel(Pools.DEFAULT, configuration.getConcurrency(), TerminationFlag.wrap(this.transaction)).build().write(configuration.get(CONFIG_CLUSTER_PROPERTY, DEFAULT_CLUSTER_PROPERTY), struct, DisjointSetStructTranslator.INSTANCE);
    }
}

